﻿// ◇
// fds: fdx68 selector
// (C)2020 GORRY.

#include "DirEntry.h"

DirEntry::DirEntry()
{
	mFileName = "";
	mType = DirEntry::Type::Unknown;
}

DirEntry::DirEntry(const std::string& filename, DirEntry::Type t)
{
	mFileName = filename;
	mType = t;

	mFileNameW = WStrUtil::str2wstr(mFileName);

	size_t len = mFileNameW.length();
	if (mType == Type::OtherFile) {
		if (len >= 5) {
			if (!WStrUtil::wstricmp(&mFileNameW[len-4], L".FDX")) {
				mType = Type::FdxFile;
			}
		}
	}
}

Directory::Directory()
{
}

void
Directory::setPath(const std::string& path)
{
	mPath = path;
}

void
Directory::getFiles(bool isRoot)
{
	mFiles.clear();

	DIR* dirp;
	dirp = opendir(mPath.c_str());
	if (dirp) {
		struct dirent* ent;
		while ((ent = readdir(dirp)) != NULL) {
			if (!strcmp(ent->d_name, ".")) {
				continue;
			}
			if (!strcmp(ent->d_name, "..")) {
				if (!isRoot) {
					mFiles.push_back(DirEntry(ent->d_name, DirEntry::Type::ParentDir));
				}
				continue;
			}
			if (ent->d_type & DT_DIR) {
				mFiles.push_back(DirEntry(ent->d_name, DirEntry::Type::Dir));
			} else if (ent->d_type & DT_REG) {
				mFiles.push_back(DirEntry(ent->d_name, DirEntry::Type::OtherFile));
			}
		}
		closedir(dirp);
	}
}

void
Directory::sortFiles()
{
	struct {
		bool operator()(const DirEntry& left, const DirEntry& right) {
			if (left.type() == right.type()) {
				return (left.filename() < right.filename());
			}
			return (left.type() < right.type());
		}
	} sortOp;
	std::sort(mFiles.begin(), mFiles.end(), sortOp);
}


// [EOF]
