﻿// ◇
// fds: fdx68 selector
// (C)2020 GORRY.

#if !defined(__DIRENTRY_H__)
#define __DIRENTRY_H__

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <locale.h>
#include <wchar.h>
#include <wctype.h>

#include <dirent.h>
#include <curses.h>

#include <algorithm>
#include <string>
#include <vector>

#include "WStrUtil.h"


class DirEntry
{
public:
	enum class Type : int {
		Unknown=-1,
		ParentDir,
		Dir,
		FdxFile,
		OtherFile,
		Max,
	};

public:
	DirEntry();
	DirEntry(const std::string& filename, Type t);
	virtual ~DirEntry() {};

	const std::string& filename() const { return mFileName; }
	const std::wstring& wfilename() const { return mFileNameW; }
	Type type() const { return mType; }
	bool isParentDir() const { return (mType == Type::ParentDir); }
	bool isNormalDir() const { return (mType == Type::Dir); }
	bool isDir() const { return (mType == Type::Dir)||(mType == Type::ParentDir); }
	bool isFdxFile() const { return (mType == Type::FdxFile); }
	bool isOtherFile() const { return (mType == Type::OtherFile); }
	bool isFile() const { return (mType == Type::OtherFile)||(mType == Type::FdxFile); }

private:

public:

private:
	std::string mFileName;
	std::wstring mFileNameW;
	Type mType;

};

class Directory
{
public:
	Directory();
	virtual ~Directory() {}

	void setPath(const std::string& path);
	const std::string& getPath() const { return mPath; }
	void getFiles(bool isRoot);
	void sortFiles();
	void clear() { mFiles.clear(); }
	const size_t size() const { return mFiles.size(); }
	const DirEntry& entry(size_t pos) const { return mFiles[pos]; }
	const DirEntry& operator[](size_t pos) const { return entry(pos); }

private:
	std::string mPath;
	std::vector<DirEntry> mFiles;

};
#endif  // __DIRENTRY_H__

// [EOF]
