﻿// ◇
// fds: fdx68 selector
// (C)2020 GORRY.

#include "DlgInput.h"

DlgInput::DlgInput()
 : mwFrame(nullptr)
{
}

DlgInput::~DlgInput()
{
	end();
}

void 
DlgInput::setText(const std::string& text)
{
	mInputText = text;
}

const std::string&
DlgInput::getText()
{
	return mInputText;
}

void 
DlgInput::setHeader(const std::string& text)
{
	mHeader = text;
}

void
DlgInput::measureSize(int &retWidth, int &retHeight)
{
	int h = 4;
	int w = mHeader.length();
	int w2 = mInputText.length();
	if (w < w2) {
		w = w2;
	}
	w += 4;
	if (w > COLS-4) {
		w = COLS-4;
	}

	retWidth = w;
	retHeight = h;
}

int
DlgInput::start(int n)
{
	int menuRet = start(-1, -1, n);
	return menuRet;
}

int
DlgInput::start(int x, int y, int n)
{
	int inputRet = -1;

	int w, h;
	measureSize(w, h);
	mTextBoxW = w-2;

	if (x < 0) {
		x = (COLS-w)/2;
	}
	if (y < 0) {
		y = (LINES-h)/2;
	}
	mwFrame = newwin(h, w, y, x);
	wborder(mwFrame, 0,0,0,0,0,0,0,0);
	wattron(mwFrame, COLOR_PAIR(FDSSystem::ColorPair::InputHeader)|A_BOLD);
	mvwaddstr(mwFrame, 1, 1, mHeader.c_str());
	wattroff(mwFrame, COLOR_PAIR(FDSSystem::ColorPair::InputHeader)|A_BOLD);
	mMaxTextLength = n;

	mWInputText = WStrUtil::str2wstr(mInputText);

	keypad(mwFrame, TRUE);
	keyEnd();

	mInsertMode = true;
	mFinish = false;
	while (!mFinish) {
		show();
		nodelay(mwFrame, false);
		wint_t wch;
		curs_set((mInsertMode ? 1 :2));
		int key = wget_wch(mwFrame, &wch);
		// fprintf(stderr, "key=%d, wch=%d\n", key, (int)wch);
		switch (wch) {
		  case 0x1b: // ESC
			{
				nodelay(mwFrame, true);
				if (FDSSystem::doEscKeyW(mwFrame)) {
					mFinish = true;
				}
				nodelay(mwFrame, false);
			}
			break;
		  case KEY_LEFT:
			keyLeft();
			break;
		  case KEY_RIGHT:
			keyRight();
			break;
		  case KEY_HOME:
			keyHome();
			break;
		  case KEY_END:
			keyEnd();
			break;
		  case 10: // ENTER
			keyEnter();
			inputRet = 0;
			mFinish = true;
			break;
		  case KEY_IC:
			keyInsert();
			break;
		  case KEY_DC:
			keyDelete();
			break;
		  case KEY_BACKSPACE:
			keyBackspace();
			break;
		  default:
			if ((key == 0) || ((key == KEY_CODE_YES) && (wch < 256))) {
				keyChar(wch);
				break;
			}
			fprintf(stderr, "key=%d, wch=%d\n", key, (int)wch);
			break;
		}
	}

	curs_set(0);

	return inputRet;
}

void
DlgInput::show()
{
	std::wstring wstr;
	int w = WStrUtil::copyByWidth(wstr, mWInputText, mTextBoxOfsX, mTextBoxW);
	wattron(mwFrame, COLOR_PAIR(FDSSystem::ColorPair::InputEdit)|A_BOLD);
	mvwaddnwstr(mwFrame, 2, 1, wstr.c_str(), mTextBoxW);
	while (w < mTextBoxW) {
		waddwstr(mwFrame, L" ");
		w++;
	}
	wattroff(mwFrame, COLOR_PAIR(FDSSystem::ColorPair::InputEdit)|A_BOLD);
	wmove(mwFrame, 2, 1+WStrUtil::widthN(wstr, 0, mTextBoxCsrX));
	wrefresh(mwFrame);
}

void
DlgInput::end()
{
	if (mwFrame) {
		delwin(mwFrame);
		mwFrame = nullptr;
	}
}

void
DlgInput::keyLeft()
{
	mTextBoxCsrX--;
	if (mTextBoxCsrX < 0) {
		mTextBoxCsrX = 0;
		mTextBoxOfsX--;
		if (mTextBoxOfsX < 0) {
			mTextBoxOfsX = 0;
		}
	}
	mTextPosX = mTextBoxOfsX+mTextBoxCsrX;
}

void
DlgInput::keyRight()
{
	if (mTextPosX < mTextLength) {
		mTextBoxCsrX++;
		while (!0) {
			int w = WStrUtil::widthN(mWInputText, mTextBoxOfsX, mTextBoxCsrX);
			if (w <= mTextBoxW-1) {
				break;
			}
			mTextBoxCsrX--;
			mTextBoxOfsX++;
		}
	}
	mTextPosX = mTextBoxOfsX+mTextBoxCsrX;
}

void
DlgInput::keyHome()
{
	mTextBoxCsrX = 0;
	mTextBoxOfsX = 0;
	mTextPosX = mTextBoxOfsX+mTextBoxCsrX;
}

void
DlgInput::keyEnd()
{
	WStrUtil::widthRightByWidth(mTextBoxCsrX, mWInputText, 0, mTextBoxW-1);
	mTextBoxOfsX = mTextLength-mTextBoxCsrX;
	mTextPosX = mTextBoxOfsX+mTextBoxCsrX;
}

void
DlgInput::keyEnter()
{
	mInputText = WStrUtil::wstr2str(mWInputText);
	// fprintf(stderr, "mInputText=[%s]\n", mInputText.c_str());
}

void
DlgInput::keyInsert()
{
	mInsertMode = !mInsertMode;
}

void
DlgInput::keyDelete()
{
	if (mTextPosX < mTextLength) {
		mWInputText.erase(mTextPosX, 1);
		mTextLength--;
		int w = WStrUtil::widthN(mWInputText, mTextBoxOfsX);
		if (w < mTextBoxW-1) {
			while (mTextBoxOfsX > 0) {
				int w = WStrUtil::widthN(mWInputText, mTextBoxOfsX);
				if (w > mTextBoxW-1) {
					mTextBoxOfsX++;
					mTextBoxCsrX--;
					break;
				}
				mTextBoxOfsX--;
				mTextBoxCsrX++;
			}
		}
	}
	mTextPosX = mTextBoxOfsX+mTextBoxCsrX;
}

void
DlgInput::keyBackspace()
{
	if (mTextPosX > 0) {
		keyLeft();
		keyDelete();
	}
}

void
DlgInput::keyChar(wint_t wch)
{
	if (mTextLength >= mMaxTextLength) {
		beep();
	} else {
		mWInputText.insert(mTextPosX, 1, wch);
		mTextLength++;
		mTextBoxCsrX++;
		while (!0) {
			int w = WStrUtil::widthN(mWInputText, mTextBoxOfsX, mTextBoxCsrX);
			if (w <= mTextBoxW-1) {
				break;
			}
			mTextBoxCsrX--;
			mTextBoxOfsX++;
		}
		mTextPosX = mTextBoxOfsX+mTextBoxCsrX;
	}
}


// [EOF]
