﻿// ◇
// fds: fdx68 selector
// (C)2020 GORRY.

#if !defined(__DLGINPUT_H__)
#define __DLGINPUT_H__

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <locale.h>
#include <wchar.h>
#include <string.h>

#include <curses.h>

#include <vector>
#include <string>

#include "FDSSystem.h"
#include "FDSMacro.h"

class DlgInput
{

public:
	DlgInput();
	virtual ~DlgInput();

	void setText(const std::string& text);
	const std::string& getText();
	void setHeader(const std::string& text);
	int start(int n);
	int start(int x, int y, int n);
	void end();

private:
	void show();
	void measureSize(int &retWidth, int &retHeight);

	void keyLeft();
	void keyRight();
	void keyHome();
	void keyEnd();
	void keyEnter();
	void keyInsert();
	void keyDelete();
	void keyBackspace();
	void keyChar(wint_t wch);


public:

private:
	std::string mInputText;
	std::wstring mWInputText;
	WINDOW *mwFrame;
	int mMaxTextLength;
	int mTextLength;
	int mTextBoxW;
	int mTextBoxOfsX;
	int mTextBoxCsrX;
	int mTextPosX;
	bool mInsertMode;
	bool mFinish;
	std::string mHeader;
};


#endif  // __DLGINPUT_H__

// [EOF]
