﻿// ◇
// fds: fdx68 selector
// (C)2020 GORRY.

#include "DlgSelect.h"

DlgSelect::DlgSelect()
 : mwFrame(nullptr)
 , mCanEscape(false)
{
}

DlgSelect::~DlgSelect()
{
	end();
}

void 
DlgSelect::setItemsVec(ItemsVec items)
{
	mSelectTxt.clear();
	for (int i=0; i<(int)items.size(); i++) {
		mSelectTxt.push_back(items[i]);
	}
}

template <int N>
void 
DlgSelect::setItemsArray(ItemsArray<N> items)
{
	mSelectTxt.clear();
	for (int i=0; i<items.size(); i++) {
		mSelectTxt.push_back(items[i]);
	}
}

void 
DlgSelect::setItemsOk()
{
	mSelectTxt.clear();
	mSelectTxt.push_back("OK");
}

void 
DlgSelect::setItemsOkCancel()
{
	mSelectTxt.clear();
	mSelectTxt.push_back("OK");
	mSelectTxt.push_back("Cancel");
}

void 
DlgSelect::setCanEscape(bool f)
{
	mCanEscape = f;
}

void 
DlgSelect::setHeader(const std::string& text)
{
	mHeader = text;
}

void
DlgSelect::measureSize(int &retWidth, int &retHeight)
{
	int h = mSelectTxt.size()+4;
	int w = mHeader.length();
	for (int i=0; i<(int)mSelectTxt.size(); i++) {
		int w2 = mSelectTxt[i].length();
		if (w < w2) {
			w = w2;
		}
	}
	w += 4;

	retWidth = w;
	retHeight = h;
}

int
DlgSelect::start(int sel)
{
	int w, h;
	measureSize(w, h);

	int menuRet = start(-1, -1, sel);
	return menuRet;
}

int
DlgSelect::start(int x, int y, int sel)
{
	int menuRet = -1;

	int w, h;
	measureSize(w, h);
	mInnerOfsX = 2;
	mInnerOfsY = 3;
	mInnerWidth = w-3;
	mSelect = sel;

	if (x < 0) {
		x = (COLS-w)/2;
	}
	if (y < 0) {
		y = (LINES-h)/2;
	}

	mwFrame = newwin(h, w, y, x);
	wborder(mwFrame, 0,0,0,0,0,0,0,0);
	wattron(mwFrame, COLOR_PAIR(FDSSystem::ColorPair::SelectHeader)|A_BOLD);
	mvwaddstr(mwFrame, 1, 2, mHeader.c_str());
	wattroff(mwFrame, COLOR_PAIR(FDSSystem::ColorPair::SelectHeader)|A_BOLD);

	keypad(mwFrame, TRUE);

	bool finish = false;
	while (!finish) {
		show();
		int key = wgetch(mwFrame);
		switch (key) {
		  case 0x1b: // ESC
			if (mCanEscape) {
				finish = true;
			}
			break;
		  case KEY_UP:
			mSelect--;
			if (mSelect < 0) {
				mSelect = (int)mSelectTxt.size()-1;
			}
			break;
		  case KEY_DOWN:
			mSelect++;
			if (mSelect > (int)mSelectTxt.size()-1) {
				mSelect = 0;
			}
			break;
		  case 10: // ENTER
			  menuRet = mSelect;
			  finish = true;
			  break;
		}
	}

	return menuRet;
}

void
DlgSelect::show()
{
	for (int i=0; i<(int)mSelectTxt.size(); i++) {
		wchar_t wbuf[256];
		wmove(mwFrame, mInnerOfsY+i, mInnerOfsX);
		if (i == mSelect) {
			wattron(mwFrame, COLOR_PAIR(FDSSystem::ColorPair::SelectItemCursor));
		}
		wmemset(wbuf, L' ', _countof(wbuf));
		wbuf[mInnerWidth] = '\0';
		waddwstr(mwFrame, wbuf);
		if (i == mSelect) {
			wattroff(mwFrame, COLOR_PAIR(FDSSystem::ColorPair::SelectItemCursor));
		}

		wmove(mwFrame, mInnerOfsY+i, mInnerOfsX+1);
		if (i == mSelect) {
			wattron(mwFrame, COLOR_PAIR(FDSSystem::ColorPair::SelectItemCursor)|A_BOLD);
			waddstr(mwFrame, mSelectTxt[i].c_str());
			wattroff(mwFrame, COLOR_PAIR(FDSSystem::ColorPair::SelectItemCursor)|A_BOLD);
		} else {
			wattron(mwFrame, COLOR_PAIR(FDSSystem::ColorPair::SelectItem));
			waddstr(mwFrame, mSelectTxt[i].c_str());
			wattroff(mwFrame, COLOR_PAIR(FDSSystem::ColorPair::SelectItem));
		}

	}
	wrefresh(mwFrame);
}

void
DlgSelect::end()
{
	if (mwFrame) {
		delwin(mwFrame);
		mwFrame = nullptr;
	}
}

// [EOF]
