﻿// ◇
// fds: fdx68 selector
// (C)2020 GORRY.

#if !defined(__DLGSELECT_H__)
#define __DLGSELECT_H__

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <locale.h>
#include <wchar.h>
#include <string.h>

#include <curses.h>

#include <vector>
#include <string>
#include <array>

#include "FDSMacro.h"
#include "FDSSystem.h"

class DlgSelect
{
public:
	using ItemsVec = std::vector<std::string>;

	template <int N>
	using ItemsArray = std::array<std::string, N>;

public:
	DlgSelect();
	virtual ~DlgSelect();

	template <int N>
	void setItemsArray(ItemsArray<N> items);
	void setItemsVec(ItemsVec items);
	void setItemsOk();
	void setItemsOkCancel();
	void setCanEscape(bool f);
	void setHeader(const std::string& text);
	int start(int sel=0);
	int start(int x, int y, int sel=0);
	void end();

private:
	void show();
	void measureSize(int &retWidth, int &retHeight);

public:

private:
	std::vector<std::string> mSelectTxt;
	WINDOW *mwFrame;
	std::string mHeader;
	int mInnerOfsX;
	int mInnerOfsY;
	int mInnerWidth;
	int mSelect;
	bool mCanEscape;
};


#endif  // __DLGSELECT_H__

// [EOF]
