﻿// ◇
// fds: fdx68 selector
// (C)2020 GORRY.

#if !defined(__FDSSYSTEM_H__)
#define __FDSSYSTEM_H__

#define FDS_VERSION "20200504a"

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <locale.h>
#include <wchar.h>
#include <string.h>

#include <dirent.h>
#include <curses.h>

#include <string>
#include <vector>
#include <algorithm>
#include <array>

#include "FDSMacro.h"
#include "DirEntry.h"
#include "DirStack.h"
#include "IniFile.h"
#include "DlgSelect.h"
#include "FddEmu.h"
#include "FDXFile.h"
#include "DlgInput.h"
#include "WStrUtil.h"

class FDSSystem
{
public:
	enum class ColorPair : short {
		Normal = 1,
		FilerParentDir,
		FilerDir,
		FilerFdxFile,
		FilerOtherFile,
		FilerParentDirCsr,
		FilerDirCsr,
		FilerFdxFileCsr,
		FilerOtherFileCsr,
		Header,
		PathHeader,
		PathRoot,
		PathCurrent,
		SelectHeader,
		SelectItem,
		SelectItemCursor,
		InputHeader,
		InputEdit,
		FddHeaderOff,
		FddHeaderOn,
		FddProtect,
		FddCluster,
		HelpHeader,
	};

	enum class HelpViewMode : int {
		ParentDir=0,
		Dir,
		FdxFile,
		OtherFile,
	};

	struct XYWH {
		int X;
		int Y;
		int W;
		int H;
		int x() const { return X; }
		int y() const { return Y; }
		int w() const { return W; }
		int h() const { return H; }
		int l() const { return X; }
		int t() const { return Y; }
		int r() const { return X+W; }
		int b() const { return Y+H; }
	};

	struct ESCKEYMAP {
		const char* keys;
		int newkey;
	};

public:
	FDSSystem();
	FDSSystem(const char* rootDir);
	virtual ~FDSSystem();

	void initialize();
	void setRootDir(const std::string& rootDir);
	void setRootDir(const char* rootDir);
	void setCurDir(const std::string& curDir);
	void setCurDir(const char* curDir);
	void start();
	void end();

	static bool doEscKey(WINDOW* window);
	static bool doEscKeyW(WINDOW* window);
	static const ESCKEYMAP sEscKeyMap[];

private:
	void mainLoop();

	void updateFiles();
	void getFiles();
	void sortFiles();
	void showFiles();

	void initView();
	void destroyView();

	void loadIniFile();

	void setViewLayout();

	const std::string& getDriveName(int id);

	// filer view
	void filerViewCreateWindow();
	void filerViewDestroyWindow();
	void filerViewSetViewTopIndex(int idx);
	int filerViewGetViewTopIndex();
	void filerViewSetCursor(int y);
	void filerViewSetPos(int pos);
	void filerViewUpCursor();
	void filerViewDownCursor();
	void filerViewPageUpCursor();
	void filerViewPageDownCursor();
	void filerViewPageTopCursor();
	void filerViewPageBottomCursor();
	int filerViewGetCursor();
	int filerViewGetPos();
	void filerViewRefresh();
	void filerViewSelectEntry();
	void filerViewBackDir();
	void filerViewRootDir();
	void filerViewShowFileInfo();

	void filerViewCmdRename();
	void filerViewCmdAutoSet();
	void filerViewCmdEjectAllDrive();

	// path view
	void pathViewCreateWindow();
	void pathViewDestroyWindow();
	void pathViewRefresh();

	// info view
	void infoViewCreateWindow();
	void infoViewDestroyWindow();
	void infoViewRefresh();
	void infoViewSetFile(const std::string& filename);

	// fdd view
	void fddViewCreateWindow();
	void fddViewDestroyWindow();
	void fddViewRefresh();

	// help view
	void helpViewCreateWindow();
	void helpViewDestroyWindow();
	void helpViewRefresh();
	void helpViewSetMode(FDSSystem::HelpViewMode md);

public:

private:
	std::string mRootDir;
	std::string mCurDir;
	Directory mFiles;

	DirStack mDirStack;

	IniFile mIniFile;

	std::string mIniSecSystem;

	FddEmu mFddEmu;

	WINDOW *mwFilerView;
	XYWH mFilerViewXYWH;
	int mFilerViewInnerW;
	int mFilerViewInnerH;
	int mFilerViewTop;
	int mFilerViewCursor;
	int mFilerViewWindowOfsX;
	int mFilerViewWindowOfsY;

	WINDOW *mwPathView;
	XYWH mPathViewXYWH;

	WINDOW *mwInfoView;
	XYWH mInfoViewXYWH;
	std::string mInfoViewFileName;

	WINDOW *mwFddView;
	XYWH mFddViewXYWH;

	WINDOW *mwHelpView;
	XYWH mHelpViewXYWH;
	FDSSystem::HelpViewMode mHelpViewMode;


};


#endif  // __FDSSYSTEM_H__

// [EOF]
