﻿// ◇
// fds: fdx68 selector
// (C)2020 GORRY.

#include "FDSSystem.h"

void
FDSSystem::fddViewCreateWindow()
{
	if (mwFddView) {
		fddViewDestroyWindow();
	}
	mwFddView = newwin(
	  mFddViewXYWH.h(),
	  mFddViewXYWH.w(),
	  mFddViewXYWH.y(),
	  mFddViewXYWH.x()
	);
	keypad(mwFddView, TRUE);
}

void
FDSSystem::fddViewDestroyWindow()
{
	if (mwFddView) {
		delwin(mwFddView);
		mwFddView = nullptr;
	}
}

void
FDSSystem::fddViewRefresh()
{
	werase(mwFddView);

	char buf[1024];
	mFddEmu.updateStatus();
	werase(mwFddView);
	for (int i=0; i<mFddEmu.Drives; i++) {
		const std::string& drive = getDriveName(i);
		const FddEmu::status& st = mFddEmu.getStatus(i); 

		if (st.mFileName != "EMPTY") {
			wattron(mwFddView, COLOR_PAIR(FDSSystem::ColorPair::FddHeaderOn)|A_BOLD);
			sprintf(buf, " %s ", drive.c_str());
			mvwaddstr(mwFddView, 1+i, 1, buf);
			wattroff(mwFddView, COLOR_PAIR(FDSSystem::ColorPair::FddHeaderOn)|A_BOLD);
			wattron(mwFddView, COLOR_PAIR(FDSSystem::ColorPair::FddCluster));
			sprintf(buf, " %02d", st.mCluster);
			waddstr(mwFddView, buf);
			wattroff(mwFddView, COLOR_PAIR(FDSSystem::ColorPair::FddCluster));
			if (st.mProtect) {
				wattron(mwFddView, COLOR_PAIR(FDSSystem::ColorPair::FddProtect)|A_BOLD);
				waddstr(mwFddView, "* ");
				wattroff(mwFddView, COLOR_PAIR(FDSSystem::ColorPair::FddProtect)|A_BOLD);
			} else {
				waddstr(mwFddView, ": ");
			}
			std::wstring str = WStrUtil::str2wstr(st.mFileName);
			waddwstr(mwFddView, str.c_str());
			mvwaddstr(mwFddView, 1+i, mFddViewXYWH.w()-2, " ");
		} else {
			wattron(mwFddView, COLOR_PAIR(FDSSystem::ColorPair::FddHeaderOff)|A_BOLD);
			sprintf(buf, " %s ", drive.c_str());
			mvwaddstr(mwFddView, 1+i, 1, buf);
			wattroff(mwFddView, COLOR_PAIR(FDSSystem::ColorPair::FddHeaderOff)|A_BOLD);
			waddstr(mwFddView, "      -- [EMPTY] --");
		}
	}
	wborder(mwFddView, 0,0,0,0,0,0,ACS_LTEE,ACS_RTEE);
	wrefresh(mwFddView);
}


// [EOF]
