﻿// ◇
// fds: fdx68 selector
// (C)2020 GORRY.

#include "FDSSystem.h"

void
FDSSystem::filerViewCreateWindow()
{
	if (mwFilerView) {
		filerViewDestroyWindow();
	}
	mwFilerView = newwin(
	  mFilerViewXYWH.h(),
	  mFilerViewXYWH.w(),
	  mFilerViewXYWH.y(),
	  mFilerViewXYWH.x()
	);
	keypad(mwFilerView, TRUE);

	mFilerViewInnerW = mFilerViewXYWH.w()-2;
	mFilerViewInnerH = mFilerViewXYWH.h()-2;
	mFilerViewTop = 0;
	mFilerViewCursor = 0;
	mFilerViewWindowOfsX = 1;
	mFilerViewWindowOfsY = 1;
}

void
FDSSystem::filerViewDestroyWindow()
{
	if (mwFilerView) {
		delwin(mwFilerView);
		mwFilerView = nullptr;
	}
}

void
FDSSystem::filerViewSetViewTopIndex(int idx)
{
	if (idx < 0) {
		idx = 0;
	}
	int h = mFiles.size() - mFilerViewInnerH;
	if (h < 0) {
		h = 0;
	}
	if (idx > h) {
		idx = h;
	}
	mFilerViewTop = idx;
}

int
FDSSystem::filerViewGetViewTopIndex()
{
	return mFilerViewTop;
}

void
FDSSystem::filerViewSetCursor(int y)
{
	if (y < 0) {
		y = 0;
	}
	int h = mFiles.size()-mFilerViewTop;
	if (h > mFilerViewInnerH) {
		h = mFilerViewInnerH;
	}
	if (y > h-1) {
		y = h-1;
	}
	mFilerViewCursor = y;
}

void
FDSSystem::filerViewSetPos(int pos)
{
	if (pos < 0) {
		pos = 0;
	}
	int h = mFiles.size()-1;
	if (pos > h) {
		pos = h;
	}
	filerViewSetViewTopIndex(pos);
	pos -= mFilerViewTop;
	filerViewSetCursor(pos);
}

void
FDSSystem::filerViewUpCursor()
{
	mFilerViewCursor--;
	if (mFilerViewCursor < 0) {
		mFilerViewCursor = 0;
		mFilerViewTop--;
		if (mFilerViewTop < 0) {
			mFilerViewTop = 0;
		}
	}
}

void
FDSSystem::filerViewDownCursor()
{
	mFilerViewCursor++;
	int h = mFiles.size()-1;
	if (mFilerViewCursor > h) {
		mFilerViewCursor = h;
	}
	h = mFilerViewInnerH-1;
	if (mFilerViewCursor >= h) {
		mFilerViewCursor = h;
		filerViewSetViewTopIndex(mFilerViewTop+1);
	}
}

void
FDSSystem::filerViewPageUpCursor()
{
	if (mFilerViewCursor > 0) {
		mFilerViewCursor = 0;
	} else {
		mFilerViewTop -= mFilerViewInnerH;
		if (mFilerViewTop < 0) {
			mFilerViewTop = 0;
		}
	}
}

void
FDSSystem::filerViewPageDownCursor()
{
	int h = mFilerViewInnerH-1;
	if (mFilerViewCursor < h) {
		mFilerViewCursor = h;
		h = mFiles.size()-1;
		if (mFilerViewCursor > h) {
			mFilerViewCursor = h;
		}
	} else {
		mFilerViewCursor = h;
		mFilerViewTop += mFilerViewInnerH;
		int h2 = mFiles.size()-mFilerViewInnerH;
		if (h2 < 0) {
			h2 = 0;
		}
		if (mFilerViewTop >= h2) {
			mFilerViewTop = h2;
		}
	}
}

void
FDSSystem::filerViewPageTopCursor()
{
	mFilerViewTop = 0;
	mFilerViewCursor = 0;
}

void
FDSSystem::filerViewPageBottomCursor()
{
	mFilerViewTop = mFiles.size()-mFilerViewInnerH;
	if (mFilerViewTop < 0) {
		mFilerViewTop = 0;
	}
	mFilerViewCursor = mFiles.size()-mFilerViewTop-1;
}

void
FDSSystem::filerViewSelectEntry()
{
	int pos = filerViewGetPos();
	if (pos >= (int)mFiles.size()) {
		return;
	}
	if (mFiles[pos].isParentDir()) {
		DirStack::Stack stack = mDirStack.pop();
		mFilerViewTop = stack.mFilerViewTop;
		mFilerViewCursor = stack.mFilerViewCursor;
		mRootDir = stack.mRootDir;
		mCurDir = stack.mCurDir;
		mFiles.setPath(mRootDir+mCurDir);
		mFiles.getFiles(mCurDir.empty());
		mFiles.sortFiles();
		pathViewRefresh();
		return;
	}
	if (mFiles[pos].isDir()) {
		DirStack::Stack stack;
		stack.mFilerViewTop = mFilerViewTop;
		stack.mFilerViewCursor = mFilerViewCursor;
		stack.mRootDir = mRootDir;
		stack.mCurDir = mCurDir;
		mDirStack.push(stack);
		setCurDir(mCurDir+mFiles[pos].filename());
		mFiles.setPath(mRootDir+mCurDir);
		mFiles.getFiles(false);
		mFiles.sortFiles();
		pathViewRefresh();
		filerViewSetPos(0);
		return;
	}

	if (mFiles[pos].isFdxFile()) {
		int sel = 0;
		DlgSelect::ItemsVec items;
		for (int i=0; i<mFddEmu.Drives; i++) {
			items.push_back(getDriveName(i));
		}
		{
			DlgSelect dlg;
			dlg.setItemsVec(items);
			dlg.setHeader("Select Drive");
			sel = dlg.start(sel);
			if (sel < 0) {
				return;
			}
		}

		std::string path = mRootDir + mCurDir + mFiles[pos].filename();
		mFddEmu.setImage(sel, path);
		fddViewRefresh();
		return;
	}
}

void
FDSSystem::filerViewBackDir()
{
	if (mDirStack.level() <= 0) {
		return;
	}

	DirStack::Stack stack = mDirStack.pop();
	mFilerViewTop = stack.mFilerViewTop;
	mFilerViewCursor = stack.mFilerViewCursor;
	mRootDir = stack.mRootDir;
	mCurDir = stack.mCurDir;
	mFiles.setPath(mRootDir+mCurDir);
	mFiles.getFiles(mCurDir.empty());
	mFiles.sortFiles();
	pathViewRefresh();
}

void
FDSSystem::filerViewRootDir()
{
	while (mDirStack.level() > 0) {
		DirStack::Stack stack = mDirStack.pop();
		mFilerViewTop = stack.mFilerViewTop;
		mFilerViewCursor = stack.mFilerViewCursor;
		mRootDir = stack.mRootDir;
		mCurDir = stack.mCurDir;
	}
	mFiles.setPath(mRootDir+mCurDir);
	mFiles.getFiles(mCurDir.empty());
	mFiles.sortFiles();
	pathViewRefresh();
}

int
FDSSystem::filerViewGetCursor()
{
	return mFilerViewCursor;
}

int
FDSSystem::filerViewGetPos()
{
	return mFilerViewTop + mFilerViewCursor;
}

void
FDSSystem::filerViewRefresh()
{
	werase(mwFilerView);
	std::wstring buf(mFilerViewInnerW, L' ');

	FDSSystem::HelpViewMode md = FDSSystem::HelpViewMode::Dir;
	int y = mFilerViewTop;
	for (int i=0; i<mFilerViewInnerH; i++) {
		bool sel = false;
		FDSSystem::ColorPair col = FDSSystem::ColorPair::Normal;
		if (y < (int)mFiles.size()) {
			col = (FDSSystem::ColorPair)((int)ColorPair::FilerParentDir + (int)mFiles[y].type());
		}
		if (i == mFilerViewCursor) {
			col = (FDSSystem::ColorPair)((int)col + (int)DirEntry::Type::Max);
			sel = true;
		}
		if (sel) {
			wattron(mwFilerView, COLOR_PAIR(col)|A_BOLD);
		} else {
			wattron(mwFilerView, COLOR_PAIR(col));
		}
		mvwaddwstr(mwFilerView, mFilerViewWindowOfsY+i, mFilerViewWindowOfsX, buf.c_str());
		if (y < (int)mFiles.size()) {
			std::wstring line;
			wmove(mwFilerView, mFilerViewWindowOfsY+i, mFilerViewWindowOfsX+1);
			switch (mFiles[y].type()) {
			  case DirEntry::Type::ParentDir:
				WStrUtil::copyByWidth(line, mFiles[y].wfilename()+L"/", 0, mFilerViewInnerW-2);
				waddwstr(mwFilerView, line.c_str());
				if (sel) {
					md = FDSSystem::HelpViewMode::ParentDir;
				}
				break;
			  case DirEntry::Type::Dir:
				WStrUtil::copyByWidth(line, mFiles[y].wfilename()+L"/", 0, mFilerViewInnerW-2);
				waddwstr(mwFilerView, line.c_str());
				if (sel) {
					md = FDSSystem::HelpViewMode::Dir;
				}
				break;
			  case DirEntry::Type::FdxFile:
				WStrUtil::copyByWidth(line, mFiles[y].wfilename(), 0, mFilerViewInnerW-2);
				waddwstr(mwFilerView, line.c_str());
				if (sel) {
					md = FDSSystem::HelpViewMode::FdxFile;
				}
				break;
			  default:
			  case DirEntry::Type::OtherFile:
				WStrUtil::copyByWidth(line, mFiles[y].wfilename(), 0, mFilerViewInnerW-2);
				waddwstr(mwFilerView, line.c_str());
				if (sel) {
					md = FDSSystem::HelpViewMode::OtherFile;
				}
				break;
			}
		}
		if (sel) {
			wattroff(mwFilerView, COLOR_PAIR(col)|A_BOLD);
		} else {
			wattroff(mwFilerView, COLOR_PAIR(col));
		}
		y++;
	}

	helpViewSetMode(md);
	helpViewRefresh();

	wborder(mwFilerView, 0,0,0,0,ACS_LTEE,ACS_RTEE,ACS_LTEE,ACS_RTEE);
	wrefresh(mwFilerView);

}

void
FDSSystem::filerViewShowFileInfo()
{
	int pos = filerViewGetPos();
	if (pos >= (int)mFiles.size()) {
		return;
	}

	std::string path = mRootDir + mCurDir + mFiles[pos].filename();
	infoViewSetFile(path);
	infoViewRefresh();
}

void
FDSSystem::filerViewCmdRename()
{
	int pos = filerViewGetPos();
	if (pos >= (int)mFiles.size()) {
		return;
	}

	std::string filename = mFiles[pos].filename();
	{
		DlgInput dlg;
		dlg.setHeader("Rename to:");
		dlg.setText(filename);
		int ret = dlg.start(256);
		if (!ret) {
			std::string src = mRootDir + mCurDir + mFiles[pos].filename();
			std::string dst = mRootDir + mCurDir + dlg.getText();
			int ret2 = rename(src.c_str(), dst.c_str());
			if (ret2 != 0) {
				fprintf(stderr, "failed: rename(%s, %s)=%d\n", src.c_str(), dst.c_str(), ret2);
			}
			mFiles.getFiles(mCurDir.empty());
			mFiles.sortFiles();
		}
	}
}


void
FDSSystem::filerViewCmdAutoSet()
{
	int pos = filerViewGetPos();
	if (pos >= (int)mFiles.size()) {
		return;
	}

	Directory mydir;
	Directory* files = &mFiles;
	std::string path = mRootDir + mCurDir;
	if (mFiles[pos].isNormalDir()) {
		path += mFiles[pos].filename()+"/";
		mydir.setPath(path);
		mydir.getFiles(true);
		mydir.sortFiles();
		files = &mydir;
	}

	for (int i=0; i<FddEmu::Drives; i++) {
		mFddEmu.ejectDrive(i);
	}
	fddViewRefresh();

	std::string path2;
	bool setDisk[FddEmu::Drives] = {};
	int disks = 0;
	for (size_t i=0; i<files->size(); i++) {
		if (files->entry(i).isFdxFile()) {
			const std::wstring& s = files->entry(i).wfilename();
			size_t len = s.length();
			wchar_t c = s[len-5];
			switch (c) {
			  case L'1':
			  case L'A':
			  case L'a':
				if (!setDisk[0]) {
					path2 = path + files->entry(i).filename();
					mFddEmu.setImage(0, path2);
					setDisk[0] = true;
					disks++;
				}
				break;
			  case L'2':
			  case L'B':
			  case L'b':
				if (!setDisk[1]) {
					path2 = path + files->entry(i).filename();
					mFddEmu.setImage(1, path2);
					setDisk[1] = true;
					disks++;
				}
				break;
			}
			if (disks >= FddEmu::Drives) break;
		}
	}
	fddViewRefresh();

	if (disks == 0) {
		DlgSelect dlg;
		dlg.setItemsOk();
		dlg.setHeader("No Disk Found!");
		dlg.start(0);
	}
}

void
FDSSystem::filerViewCmdEjectAllDrive()
{
	for (int i=0; i<FddEmu::Drives; i++) {
		mFddEmu.ejectDrive(i);
	}
	fddViewRefresh();
}



// [EOF]
