﻿// ◇
// fds: fdx68 selector
// (C)2020 GORRY.

#include "FDSSystem.h"

void
FDSSystem::helpViewCreateWindow()
{
	if (mwHelpView) {
		helpViewDestroyWindow();
	}
	mwHelpView = newwin(
	  mHelpViewXYWH.h(),
	  mHelpViewXYWH.w(),
	  mHelpViewXYWH.y(),
	  mHelpViewXYWH.x()
	);
	keypad(mwHelpView, TRUE);

	mHelpViewMode = HelpViewMode::Dir;
}

void
FDSSystem::helpViewDestroyWindow()
{
	if (mwHelpView) {
		delwin(mwHelpView);
		mwHelpView = nullptr;
	}
}

void
FDSSystem::helpViewRefresh()
{
	werase(mwHelpView);

	wattron(mwHelpView, COLOR_PAIR(FDSSystem::ColorPair::HelpHeader)|A_BOLD);
	mvwaddstr(mwHelpView,  1, 1, "[KEY INSTRUCTION]");
	wattroff(mwHelpView, COLOR_PAIR(FDSSystem::ColorPair::HelpHeader)|A_BOLD);

	switch (mHelpViewMode) {
	  default:
	  case HelpViewMode::Dir:
		mvwaddstr(mwHelpView,  3, 1, (1 ? "A: Auto Set Disk" : ""));
		mvwaddstr(mwHelpView,  4, 1, (1 ? "C: Create Disk" : ""));
		mvwaddstr(mwHelpView,  5, 1, (0 ? "D: Dup Disk" : ""));
		mvwaddstr(mwHelpView,  6, 1, (1 ? "E: Eject Drive" : ""));
		mvwaddstr(mwHelpView,  7, 1, (0 ? "I: Disk Info" : ""));
		mvwaddstr(mwHelpView,  8, 1, (1 ? "K: Make Directory" : ""));
		mvwaddstr(mwHelpView,  9, 1, (0 ? "N: Edit Name" : ""));
		mvwaddstr(mwHelpView, 10, 1, (0 ? "P: Protect Disk" : ""));
		mvwaddstr(mwHelpView, 11, 1, (1 ? "R: Rename Dir" : ""));
		mvwaddstr(mwHelpView, 12, 1, (1 ? "Z: Drive Protect" : ""));
		mvwaddstr(mwHelpView, 14, 1, (0 ? "1: Set 1st Drive" : ""));
		mvwaddstr(mwHelpView, 15, 1, (0 ? "2: Set 2nd Drive" : ""));
		mvwaddstr(mwHelpView, 16, 1, (1 ? "0: Eject All" : ""));
		break;
	  case HelpViewMode::ParentDir:
		mvwaddstr(mwHelpView,  3, 1, (0 ? "A: Auto Set Disk" : ""));
		mvwaddstr(mwHelpView,  4, 1, (1 ? "C: Create Disk" : ""));
		mvwaddstr(mwHelpView,  5, 1, (0 ? "D: Dup Disk" : ""));
		mvwaddstr(mwHelpView,  6, 1, (1 ? "E: Eject Drive" : ""));
		mvwaddstr(mwHelpView,  7, 1, (0 ? "I: Disk Info" : ""));
		mvwaddstr(mwHelpView,  8, 1, (1 ? "K: Make Directory" : ""));
		mvwaddstr(mwHelpView,  9, 1, (0 ? "N: Edit Name" : ""));
		mvwaddstr(mwHelpView, 10, 1, (0 ? "P: Protect Disk" : ""));
		mvwaddstr(mwHelpView, 11, 1, (0 ? "R: Rename Dir" : ""));
		mvwaddstr(mwHelpView, 12, 1, (1 ? "Z: Drive Protect" : ""));
		mvwaddstr(mwHelpView, 14, 1, (0 ? "1: Set 1st Drive" : ""));
		mvwaddstr(mwHelpView, 15, 1, (0 ? "2: Set 2nd Drive" : ""));
		mvwaddstr(mwHelpView, 16, 1, (1 ? "0: Eject All" : ""));
		break;
	  case HelpViewMode::FdxFile:
		mvwaddstr(mwHelpView,  3, 1, (1 ? "A: Auto Set" : ""));
		mvwaddstr(mwHelpView,  4, 1, (1 ? "C: Create Disk" : ""));
		mvwaddstr(mwHelpView,  5, 1, (1 ? "D: Dup Disk" : ""));
		mvwaddstr(mwHelpView,  6, 1, (1 ? "E: Eject Drive" : ""));
		mvwaddstr(mwHelpView,  7, 1, (1 ? "I: Disk Info" : ""));
		mvwaddstr(mwHelpView,  8, 1, (1 ? "K: Make Directory" : ""));
		mvwaddstr(mwHelpView,  9, 1, (1 ? "N: Edit Name" : ""));
		mvwaddstr(mwHelpView, 10, 1, (1 ? "P: Protect Disk" : ""));
		mvwaddstr(mwHelpView, 11, 1, (1 ? "R: Rename Disk" : ""));
		mvwaddstr(mwHelpView, 12, 1, (1 ? "Z: Drive Protect" : ""));
		mvwaddstr(mwHelpView, 14, 1, (1 ? "1: Set 1st Drive" : ""));
		mvwaddstr(mwHelpView, 15, 1, (1 ? "2: Set 2nd Drive" : ""));
		mvwaddstr(mwHelpView, 16, 1, (1 ? "0: Eject All" : ""));
		break;
	  case HelpViewMode::OtherFile:
		mvwaddstr(mwHelpView,  3, 1, (1 ? "A: Auto Set" : ""));
		mvwaddstr(mwHelpView,  4, 1, (1 ? "C: Create Disk" : ""));
		mvwaddstr(mwHelpView,  5, 1, (0 ? "D: Dup Disk" : ""));
		mvwaddstr(mwHelpView,  6, 1, (1 ? "E: Eject Drive" : ""));
		mvwaddstr(mwHelpView,  7, 1, (0 ? "I: Disk Info" : ""));
		mvwaddstr(mwHelpView,  8, 1, (1 ? "K: Make Directory" : ""));
		mvwaddstr(mwHelpView,  9, 1, (0 ? "N: Edit Name" : ""));
		mvwaddstr(mwHelpView, 10, 1, (0 ? "P: Protect Disk" : ""));
		mvwaddstr(mwHelpView, 11, 1, (0 ? "R: Rename Disk" : ""));
		mvwaddstr(mwHelpView, 12, 1, (1 ? "Z: Drive Protect" : ""));
		mvwaddstr(mwHelpView, 14, 1, (0 ? "1: Set 1st Drive" : ""));
		mvwaddstr(mwHelpView, 15, 1, (0 ? "2: Set 2nd Drive" : ""));
		mvwaddstr(mwHelpView, 16, 1, (1 ? "0: Eject All" : ""));
		break;
	}

	wborder(mwHelpView, 0,0,0,0,0,0,0,0);
	wrefresh(mwHelpView);
}

void
FDSSystem::helpViewSetMode(FDSSystem::HelpViewMode md)
{
	mHelpViewMode = md;
}


// [EOF]
