﻿// ◇
// fds: fdx68 selector
// (C)2020 GORRY.

#include "FDSSystem.h"

void
FDSSystem::infoViewCreateWindow()
{
	if (mwInfoView) {
		infoViewDestroyWindow();
	}
	mwInfoView = newwin(
	  mInfoViewXYWH.h(),
	  mInfoViewXYWH.w(),
	  mInfoViewXYWH.y(),
	  mInfoViewXYWH.x()
	);
	keypad(mwInfoView, TRUE);
}

void
FDSSystem::infoViewDestroyWindow()
{
	if (mwInfoView) {
		delwin(mwInfoView);
		mwInfoView = nullptr;
	}
}

void
FDSSystem::infoViewRefresh()
{
	fdxheader_t disk;
	char buf[4][256];
	memset(&disk, 0, sizeof(disk));
	buf[0][0] = '\0';
	buf[1][0] = '\0';
	buf[2][0] = '\0';
	buf[3][0] = '\0';

	werase(mwInfoView);

	if (mInfoViewFileName.empty()) {
		goto end;
	}

	{
		FILE *fin = fopen(mInfoViewFileName.c_str(), "rb");
		if (fin == nullptr) {
			goto err_cannotopen;
		}
		fread(&disk, 1, 256, fin);
		fclose(fin);
	}

	if (memcmp(&disk.signature, "FDX", 3)) {
		goto err_notfdx;
	}

	if (disk.revision > 3) {
		goto err_fdxrevision;
	}

	{
		char buf2[64];
		const char* disktype = "???";

		memcpy(buf2, &disk.name[0], sizeof(disk.name));
		buf2[sizeof(disk.name)] = '\0';
		switch (disk.type) {
		  case 0:
			disktype = "2D";
			break;
		  case 1:
			disktype = ((disk.rpm == 300) ? "2DD(720KB)" : "2DD(640KB)");
			break;
		  case 2:
			disktype = ((disk.rpm == 300) ? "2HD(1.4MB)" : "2HD(1.4MB)");
			break;
		  case 9:
			disktype = "RAW";
			break;
		  default:
			break;
		}

		sprintf(&buf[0][0], "[FDX rev%d %s] Protect:%s", 
		  (int)disk.revision, disktype, 
		  (disk.writeprotect ? "ON" : "OFF")
		);
		sprintf(&buf[1][0], "%d Cyl, %d Head, %d Samples/Trk", 
		  disk.cylinders,
		  disk.heads,
		  disk.tracksiz
		);
		sprintf(&buf[2][0], "Rate:%dkbps, Motor:%drpm",
		  disk.rate,
		  disk.rpm
		);
		sprintf(&buf[3][0], "Name:[%s]",
		  buf2
		);
	}
	goto end;

  err_cannotopen:;
	sprintf(&buf[0][0], "[Cannot Read File]");
	goto end;

  err_notfdx:;
	sprintf(&buf[0][0], "[Not FDX File]");
	goto end;

  err_fdxrevision:;
	sprintf(&buf[0][0], "[Not Support FDX revision %d]", disk.revision);
	goto end;

  end:;
	mvwaddstr(mwInfoView, 1, 1, &buf[0][0]);
	mvwaddstr(mwInfoView, 2, 1, &buf[1][0]);
	mvwaddstr(mwInfoView, 3, 1, &buf[2][0]);
	mvwaddstr(mwInfoView, 4, 1, &buf[3][0]);

	wborder(mwInfoView, 0,0,0,0,ACS_LTEE,ACS_RTEE,0,0);
	wrefresh(mwInfoView);
}

void
FDSSystem::infoViewSetFile(const std::string& filename)
{
	mInfoViewFileName = filename;
}


// [EOF]
