﻿// ◇
// fds: fdx68 selector
// (C)2020 GORRY.

#include "FDSSystem.h"

void
FDSSystem::pathViewCreateWindow()
{
	if (mwPathView) {
		pathViewDestroyWindow();
	}
	mwPathView = newwin(
	  mPathViewXYWH.h(),
	  mPathViewXYWH.w(),
	  mPathViewXYWH.y(),
	  mPathViewXYWH.x()
	);
	keypad(mwPathView, TRUE);
}

void
FDSSystem::pathViewDestroyWindow()
{
	if (mwPathView) {
		delwin(mwPathView);
		mwPathView = nullptr;
	}
}

void
FDSSystem::pathViewRefresh()
{
	werase(mwPathView);

	wattron(mwPathView, COLOR_PAIR(ColorPair::PathHeader)|A_BOLD);
	mvwaddstr(mwPathView, 1, 1, "[DIR] ");
	wattroff(mwPathView, COLOR_PAIR(ColorPair::PathHeader)|A_BOLD);

	wattron(mwPathView, COLOR_PAIR(ColorPair::PathRoot));
	std::wstring wroot = WStrUtil::str2wstr(mRootDir);
	waddwstr(mwPathView, wroot.c_str());
	wattroff(mwPathView, COLOR_PAIR(ColorPair::PathRoot));

	wattron(mwPathView, COLOR_PAIR(ColorPair::PathCurrent)|A_BOLD);
	std::wstring wcurrent = WStrUtil::str2wstr(mCurDir);
	if (wcurrent.empty()) {
		wcurrent = L"/";
	}
	mvwaddwstr(mwPathView, 2, 7, wcurrent.c_str());
	wattroff(mwPathView, COLOR_PAIR(ColorPair::PathCurrent)|A_BOLD);

	mvwaddstr(mwPathView, 2, mPathViewXYWH.w()-2, " ");

	wborder(mwPathView, 0,0,0,0,ACS_LTEE,ACS_RTEE,ACS_LTEE,ACS_RTEE);
	wrefresh(mwPathView);
}


// [EOF]
