﻿// ◇
// fds: fdx68 selector
// (C)2020 GORRY.

#if !defined(__FDXFILE_H__)
#define __FDXFILE_H__

typedef struct {
	uint8_t signature[3];	// 識別子('F','D','X')
	uint8_t revision;		// リビジョン(3)
	uint8_t name[60];		// ディスク名
	uint8_t pad[4];			// パディング
	int32_t type;			// タイプ(0:2D 1:2DD 2:2HD 9:RAW)
	int32_t cylinders;		// シリンダー数
	int32_t heads;			// ヘッド数
	int32_t rate;			// 転送レート(クロック込み)[500|1000]
	int32_t rpm;			// RPM[300|360]
	bool writeprotect;		// ライトプロテクト(0: OFF 1:ON)
	uint32_t option;		// 動作オプション
	uint32_t unused;		// 未使用
	int32_t tracksiz;		// トラックデータのブロック長
	uint8_t reserve[152];	// リザーブ(ヘッダー全体256バイトに調整)
} fdxheader_t;


#endif  // __FDXFILE_H__

// [EOF]
