﻿// ◇
// fds: fdx68 selector
// (C)2020 GORRY.

#include "FddEmu.h"

FddEmu::FddEmu()
{
	for (int i=0; i<Drives; i++) {
		mStatus[i] = {};
	}
}

void
FddEmu::setCmd(const std::string& cmd)
{
	mCmd = cmd;
}

void
FddEmu::setOption(const std::string& option)
{
	mOption = option;
}

int
FddEmu::run()
{
#if !defined(NOSUDO)
	pid_t pid = fork();
	if (pid < 0) {
		fprintf(stderr, "cannot fork()");
		return -1;
	}
	if (pid == 0) {
		FILE* flog = fopen("fddemu.log", "a+");
		if (flog) {
			dup2(fileno(flog), STDOUT_FILENO);
			dup2(fileno(flog), STDERR_FILENO);
			fclose(flog);
		}
		std::vector<const char*> argv = makeArgv(mCmd, mOption);
		execvp(mCmd.c_str(), (char* const*)&argv[0]);
		exit(1);
		return 0;
	}

	mPid = pid;

	while (!0) {
		bool ret = updateStatus();
		if (ret) break;
		sleep(1);
	}
#endif  // !defined(NOSUDO)

	return 0;
}

void
FddEmu::kill()
{
#if !defined(NOSUDO)
	if (mPid == 0) {
		fprintf(stderr, "not fork()");
		return;
	}
	::kill(mPid, SIGHUP);
#endif  // !defined(NOSUDO)
}

std::vector<const char*>
FddEmu::makeArgv(const std::string& cmd, const std::string& option)
{
	mArgv.clear();
	mArgv.push_back(cmd.c_str());

	int mode = 0;
	char c = 0;
	char c2 = 0;
	const char* p = option.c_str();
	std::string arg;
	while ((c = *(p++)) != '\0') {
		switch (mode) {
		  default:
		  case 0:
			if ((c == ' ') || (c == '\t')) {
				continue;
			}
			if (c == '\\') {
				c = *(p++);
				if (c == '\0') goto finish;
				arg.push_back(c);
				mode = 1;
				continue;
			}
			if ((c == '\'') || (c == '\"')) {
				arg.push_back(c);
				c2 = c;
				mode = 2;
				continue;
			}
			arg.push_back(c);
			mode = 1;
			continue;
		  case 1:
			if ((c == ' ') || (c == '\t')) {
				mArgv.push_back(arg);
				arg.clear();
				mode = 0;
				continue;
			}
			if (c == '\\') {
				c = *(p++);
				if (c == '\0') goto finish;
				arg.push_back(c);
				continue;
			}
			if ((c == '\'') || (c == '\"')) {
				arg.push_back(c);
				c2 = c;
				mode = 2;
				continue;
			}
			mode = 1;
			arg.push_back(c);
			continue;
		  case 2:
			if (c == '\\') {
				c = *(p++);
				if (c == '\0') goto finish;
				arg.push_back(c);
				continue;
			}
			if (c == c2) {
				arg.push_back(c);
				mode = 1;
				continue;
			}
			arg.push_back(c);
			continue;
		}

	  finish:;
		break;
	}
	if (!arg.empty()) {
		mArgv.push_back(arg);
	}

	std::vector<const char*> argv;
	for (int i=0; i<(int)mArgv.size(); i++) {
		argv.push_back(mArgv[i].c_str());
	}
	argv.push_back(nullptr);

	return argv;
}

bool
FddEmu::updateStatus()
{
	bool ret = sendCommand("list\n", true);
	return ret;
}

bool
FddEmu::setImage(int id, const std::string& filename)
{
	char buf[256];
	sprintf(buf, "%d %d %s\n", id, (int)Command::Insert, filename.c_str());
	bool ret = sendCommand(buf, false);
	return ret;
}

bool
FddEmu::ejectDrive(int id)
{
	char buf[256];
	sprintf(buf, "%d %d %s\n", id, (int)Command::Eject, "-");
	bool ret = sendCommand(buf, false);
	return ret;
}

bool
FddEmu::protectDrive(int id)
{
	char buf[256];
	sprintf(buf, "%d %d %s\n", id, (int)Command::Protect, "-");
	bool ret = sendCommand(buf, false);
	return ret;
}

bool
FddEmu::sendCommand(const std::string& command, bool getStatus)
{
#if !defined(NOSUDO)
	if (mPid == 0) {
		fprintf(stderr, "not fork()");
		return false;
	}

	int fd;
	struct sockaddr_in server;
	FILE *fp;

	fd = socket(PF_INET, SOCK_STREAM, 0);
	memset(&server, 0, sizeof(server));
	server.sin_family = PF_INET;
	server.sin_port   = htons(FDDEMU_PORTNO);
	server.sin_addr.s_addr = htonl(INADDR_LOOPBACK); 

	if (connect(fd, (struct sockaddr *)&server,
		sizeof(struct sockaddr_in)) < 0) {
		if (!getStatus) {
			fprintf(stderr, "Error : Can't connect to fddemu process\n");
		}
		return false;
	}

	fp = fdopen(fd, "r+");
	setvbuf(fp, NULL, _IONBF, 0);
	fprintf(fp, "%s", command.c_str());

	while (1) {
		char buf[1024];
		if (fgets((char *)buf, sizeof(buf), fp) == NULL) {
			break;
		}
		if (getStatus) {
			if ((buf[2] == '0') || (buf[2] == '1')) {
				int id = atoi(&buf[2]);
				mStatus[id].mProtect = (buf[6] == 'O');
				mStatus[id].mCluster = atoi(&buf[11]);
				buf[strlen(buf)-1] = '\0';
				mStatus[id].mFileName = &buf[16];
				// fprintf(stderr, "ID=%d, WP=%d, CL=%02d, NAME=[%s]\n", id, (mStatus[id].mProtect ? 1 : 0), mStatus[id].mCluster, mStatus[id].mFileName.c_str());
			}
		}
	}

	fclose(fp);
	close(fd);

#endif  // !defined(NOSUDO)
	return true;
}


// [EOF]
