﻿// ◇
// fds: fdx68 selector
// (C)2020 GORRY.

#if !defined(__FDDEMU_H__)
#define __FDDEMU_H__

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include <signal.h>

#if !defined(NOSUDO)
#include <unistd.h>
#include <sys/wait.h>
#include <sys/socket.h>
#include <netinet/in.h>
#endif

#include <vector>
#include <string>


#define FDDEMU_PORTNO 6869

class FddEmu
{
public:
	struct status {
		int mId;
		bool mProtect;
		int mCluster;
		std::string mFileName;
	};

	static const int Drives = 2;

public:
	FddEmu();
	virtual ~FddEmu() {}

	void setCmd(const std::string& cmd);
	void setOption(const std::string& option);
	int run();
	void kill();
	bool updateStatus();
	const status& getStatus(int id) const { return mStatus[id]; }
	bool setImage(int id, const std::string& filename);
	bool ejectDrive(int id);
	bool protectDrive(int id);

private:
	std::vector<const char*> makeArgv(const std::string& cmd, const std::string& option);
	bool sendCommand(const std::string& command, bool getStatus);

public:

private:
	std::string mCmd;
	std::string mOption;
	std::vector<std::string> mArgv;
#if !defined(NOSUDO)
	pid_t mPid;
#endif
	status mStatus[2];

	enum class Command : int {
		List = 0,
		Insert,
		Eject,
		Protect,
	};

};


#endif  // __FDDEMU_H__

// [EOF]
