﻿// ◇
// fds: fdx68 selector
// (C)2020 GORRY.

#include "IniFile.h"

IniFile::IniFile()
{
}

int
IniFile::load(const char* filename)
{
	std::string section;
	std::string key;
	std::string value;

	FILE *fin = fopen(filename, "r");
	if (fin == nullptr) {
		return -1;
	}

	while (!feof(fin)) {
		char buf[1024];
		if (!fgets(buf, sizeof(buf), fin)) {
			break;
		}

		char* p = &buf[0];
		char c;
		int mode = 0;
		while ((c = *(p++)) != '\0') {
			switch (mode) {
			  default:
			  case 0:
				if ((c == 0x0d) || (c == 0x0a) || (c == 0x1a)) {
					continue;
				}
				if ((c == ' ') || (c == '\t')) {
					continue;
				}
				if (c == '#') {
					goto newline;
				}
				if (c == '[') {
					section.clear();
					mode = 1;
					continue;
				}
				key.clear();
				key.push_back(c);
				mode = 2;
				continue;

			  case 1:
				if (c == ']') {
					goto newline;
				}
				section.push_back(c);
				continue;

			  case 2:
				if (c == '=') {
					value.clear();
					mode = 3;
					continue;
				}
				key.push_back(c);
				continue;

			  case 3:
				if ((c == 0x0d) || (c == 0x0a) || (c == 0x1a)) {
					std::string sectionkey = section + ":" + key;
					mIniFileMap.insert(std::make_pair(sectionkey, value));
					goto newline;
				}
				value.push_back(c);
				continue;

			  case 4:
				if ((c == 0x0d) || (c == 0x0a) || (c == 0x1a)) {
					mode = 0;
				}
				continue;

			  newline:
				mode = 4;
				continue;
			}
		}
	}

	fclose(fin);
	return 0;
}

const std::string
IniFile::getString(const std::string& section, const std::string& key)
{
	std::string sectionkey = section + ":" + key;
	return mIniFileMap[sectionkey];
}

#if 0
const std::string
IniFile::getString(const char* section, const char* key)
{
	std::string strsection(section);
	std::string strkey(key);
	std::string sectionkey = strsection + ":" + strkey;
	return mIniFileMap[sectionkey];
}
#endif

int
IniFile::getInt(const std::string& section, const std::string& key)
{
	std::string sectionkey = section + ":" + key;
	return atoi(mIniFileMap[sectionkey].c_str());
}

#if 0
int
IniFile::getInt(const char* section, const char* key)
{
	std::string strsection(section);
	std::string strkey(key);
	std::string sectionkey = strsection + ":" + strkey;
	return atoi(mIniFileMap[sectionkey].c_str());
}
#endif

// [EOF]
