﻿// ◇
// fds: fdx68 selector
// (C)2020 GORRY.

#include "WStrUtil.h"

int
WStrUtil::copyNRight(std::wstring& dst, const std::wstring& src, int offset, int len)
{
	int srclen = src.length();
	if (offset < 0) {
		offset = 0;
	}
	if (offset > srclen) {
		offset = srclen;
	}
	if (len < 0) {
		len = INT_MAX;
	}

	int x = srclen-len;
	if (x < offset) {
		x = offset;
	}
	dst = std::wstring(&src[x]);
	return srclen-x;
}

int
WStrUtil::copyByWidth(std::wstring& dst, const std::wstring& src, int offset, int width)
{
	int srclen = src.length();
	if (offset < 0) {
		offset = 0;
	}
	if (offset > srclen) {
		offset = srclen;
	}
	if (width < 0) {
		width = INT_MAX;
	}

	int x = offset;
	int w = 0;
	dst.clear();
	while (w < width) {
		wchar_t c = src[x++];
		if (c == L'\0') {
			break;
		}
		int w2 = wcwidth(c);
		if (w+w2 > width) {
			break;
		}
		dst.push_back(c);
		w += w2;
	}
	return w;
}

int
WStrUtil::copyRightByWidth(std::wstring& dst, const std::wstring& src, int offset, int width)
{
	int srclen = src.length();
	if (offset < 0) {
		offset = 0;
	}
	if (offset > srclen) {
		offset = srclen;
	}
	if (width < 0) {
		width = INT_MAX;
	}

	int x = srclen-1;
	int w = 0;
	while (w < width) {
		if (x < offset) {
			break;
		}
		wchar_t c = src[x];
		int w2 = wcwidth(c);
		if (w+w2 > width) {
			break;
		}
		w += w2;
		x--;
	}
	dst = std::wstring(&src[x]);
	return w;
}

int
WStrUtil::widthByWidth(int& retLen, const std::wstring& src, int offset, int width)
{
	int srclen = src.length();
	if (offset < 0) {
		offset = 0;
	}
	if (offset > srclen) {
		offset = srclen;
	}
	if (width < 0) {
		width = INT_MAX;
	}

	int x = offset;
	int w = 0;
	int len = 0;
	while (w < width) {
		wchar_t c = src[x++];
		if (c == L'\0') {
			break;
		}
		int w2 = wcwidth(c);
		if (w+w2 > width) {
			break;
		}
		w += w2;
		len++;
	}
	retLen = len;
	return w;
}

int
WStrUtil::widthRightByWidth(int& retLen, const std::wstring& src, int offset, int width)
{
	int srclen = src.length();
	if (offset < 0) {
		offset = 0;
	}
	if (offset > srclen) {
		offset = srclen;
	}
	if (width < 0) {
		width = INT_MAX;
	}

	int x = srclen-1;
	int w = 0;
	while (w < width) {
		if (x < offset) {
			break;
		}
		wchar_t c = src[x];
		int w2 = wcwidth(c);
		if (w+w2 > width) {
			break;
		}
		w += w2;
		x--;
	}
	retLen = srclen-x;
	return w;
}

int
WStrUtil::widthN(const std::wstring& src, int offset, int len)
{
	int srclen = src.length();
	if (offset < 0) {
		offset = 0;
	}
	if (offset > srclen) {
		offset = srclen;
	}
	if (len < 0) {
		len = INT_MAX;
	}

	int x = offset;
	int w = 0;
	while (len > 0) {
		wchar_t c = src[x++];
		if (c == L'\0') {
			break;
		}
		int w2 = wcwidth(c);
		w += w2;
		len--;
	}
	return w;
}

int
WStrUtil::widthNRight(const std::wstring& src, int offset, int len)
{
	int srclen = src.length();
	if (offset < 0) {
		offset = 0;
	}
	if (offset > srclen) {
		offset = srclen;
	}
	if (len < 0) {
		len = INT_MAX;
	}

	int x = srclen-1;
	int w = 0;
	while (len > 0) {
		if ((x < 0) || (x < offset)) {
			break;
		}
		wchar_t c = src[x];
		int w2 = wcwidth(c);
		w += w2;
		len--;
		x--;
	}
	return w;
}

std::wstring WStrUtil::str2wstr(const std::string& str)
{
	size_t len = str.length();
	wchar_t* buf = new wchar_t[len+1];
	mbstowcs(buf, str.c_str(), len+1);
	buf[len] = L'\0';
	std::wstring wstr(buf);
	delete buf;

	return wstr;
}

std::string WStrUtil::wstr2str(const std::wstring& wstr)
{
	size_t len = wstr.length();
	char* buf = new char[len+1];
	wcstombs(buf, wstr.c_str(), len+1);
	buf[len] = '\0';
	std::string str(buf);
	delete buf;

	return str;
}

int WStrUtil::wstricmp(const std::wstring& wstr1, const std::wstring& wstr2)
{
	const wchar_t* p1 = &wstr1[0];
	const wchar_t* p2 = &wstr2[0];
	while (!0) {
		wchar_t c1 = towupper(*(p1++));
		wchar_t c2 = towupper(*(p2++));
		if (c1 != c2) {
			return ((c1 > c2) ? 1 : -1);
		}
		if (c1 == L'\0') {
			return 0;
		}
	}
	// not reached
	return 0;
}


// [EOF]
