﻿// ◇
// fds: fdx68 selector
// (C)2020 GORRY.

#if !defined(__WSTRUTIL_H__)
#define __WSTRUTIL_H__

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <locale.h>
#include <wchar.h>
#include <wctype.h>
#include <string.h>
#include <limits.h>

#include <string>

#include "FDSMacro.h"
#if defined(WIN32)
#include "wcwidth.h"
#endif

class WStrUtil
{
public:
	static int copyNRight(std::wstring& dst, const std::wstring& src, int offset, int len=-1);
	static int copyByWidth(std::wstring& dst, const std::wstring& src, int offset, int width=-1);
	static int copyRightByWidth(std::wstring& dst, const std::wstring& src, int offset, int width=-1);
	static int widthByWidth(int& retLen, const std::wstring& src, int offset, int width=-1);
	static int widthRightByWidth(int& retLen, const std::wstring& src, int offset, int width=-1);
	static int widthN(const std::wstring& src, int offset, int len=-1);
	static int widthNRight(const std::wstring& src, int offset, int len=-1);

	static std::wstring str2wstr(const std::string& str);
	static std::string wstr2str(const std::wstring& wstr);
	static int wstricmp(const std::wstring& wstr1, const std::wstring& wstr2);

};


#endif  // __WSTRUTIL_H__

// [EOF]
