﻿// ◇
// fds: fdx68 selector
// (C)2020 GORRY.

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <locale.h>
#include <wchar.h>

#include "FDSSystem.h"

#if defined(WIN32)
int setenv(const char *name, const char *value, int overwrite)
{
	int err = 0;
	if (!overwrite) {
		size_t size = 0;
		err = getenv_s(&size, NULL, 0, name);
		if (err || size) return err;
	}
	return _putenv_s(name, value);
}
#endif

int main(int argc, char **argv)
{
	FDSSystem sys;

	char* env = getenv("LANG");
	setlocale(LC_ALL, env);

	setenv("ESCDELAY", "10", 1);

	if (argc >= 2) {
		sys.setRootDir(argv[argc - 1]);
	}
	sys.start();
	sys.end();

	// getchar();
	return 0;
}

// [EOF]
