/*******************************************************************************************
 * setup softkeyboard(NicoTouch)
 */
package net.gorry.android.input.nicownng.JAJP;

import java.util.HashMap;

import net.gorry.android.input.nicownng.DefaultSoftKeyboard;
import net.gorry.android.input.nicownng.MyHeightKeyboard;
import net.gorry.android.input.nicownng.NicoWnnG;
import net.gorry.android.input.nicownng.R;
import android.inputmethodservice.Keyboard;

public class SetupKeyboardNico implements SetupKeyboard {

	/******************************************************************************************/
	/*********************************
	 *
	 */
	public MyHeightKeyboard[][][] SetupSoftKeyboard(final NicoWnnG parent, final int displaymode, final int keysize, final int flick, final boolean showFlick) {
		final MyHeightKeyboard[][][] nicokeyboard = new MyHeightKeyboard[3][11][6];
		MyHeightKeyboard[][] k;
		int[] t;
		boolean isPortrait = (DefaultSoftKeyboard.PORTRAIT == displaymode);

		if ((flick != DefaultSoftKeyboard.NICOFLICK_NONE) && showFlick) {
			if (isPortrait) {
				t = selectFlickPortKeyTable;
			} else {
				t = selectFlickLandKeyTable;
			}
		} else {
			if (isPortrait) {
				t = selectPortKeyTable;
			} else {
				t = selectLandKeyTable;
			}
		}
		{
			k = nicokeyboard[DefaultSoftKeyboard.NICO_MODE_FULL_HIRAGANA];
			k[DefaultSoftKeyboard.NICO_SLIDE_MODE_TOP][0]   = new MyHeightKeyboard(parent, t[0], keysize, DefaultSoftKeyboard.KEYTYPE_12KEY, isPortrait);
			k[DefaultSoftKeyboard.NICO_SLIDE_MODE_A][0]     = new MyHeightKeyboard(parent, t[1], keysize, DefaultSoftKeyboard.KEYTYPE_12KEY, isPortrait);
			k[DefaultSoftKeyboard.NICO_SLIDE_MODE_K][0]     = new MyHeightKeyboard(parent, t[2], keysize, DefaultSoftKeyboard.KEYTYPE_12KEY, isPortrait);
			k[DefaultSoftKeyboard.NICO_SLIDE_MODE_S][0]     = new MyHeightKeyboard(parent, t[3], keysize, DefaultSoftKeyboard.KEYTYPE_12KEY, isPortrait);
			k[DefaultSoftKeyboard.NICO_SLIDE_MODE_T][0]     = new MyHeightKeyboard(parent, t[4], keysize, DefaultSoftKeyboard.KEYTYPE_12KEY, isPortrait);
			k[DefaultSoftKeyboard.NICO_SLIDE_MODE_N][0]     = new MyHeightKeyboard(parent, t[5], keysize, DefaultSoftKeyboard.KEYTYPE_12KEY, isPortrait);
			k[DefaultSoftKeyboard.NICO_SLIDE_MODE_H][0]     = new MyHeightKeyboard(parent, t[6], keysize, DefaultSoftKeyboard.KEYTYPE_12KEY, isPortrait);
			k[DefaultSoftKeyboard.NICO_SLIDE_MODE_M][0]     = new MyHeightKeyboard(parent, t[7], keysize, DefaultSoftKeyboard.KEYTYPE_12KEY, isPortrait);
			k[DefaultSoftKeyboard.NICO_SLIDE_MODE_Y][0]     = new MyHeightKeyboard(parent, t[8], keysize, DefaultSoftKeyboard.KEYTYPE_12KEY, isPortrait);
			k[DefaultSoftKeyboard.NICO_SLIDE_MODE_R][0]     = new MyHeightKeyboard(parent, t[9], keysize, DefaultSoftKeyboard.KEYTYPE_12KEY, isPortrait);
			k[DefaultSoftKeyboard.NICO_SLIDE_MODE_W][0]     = new MyHeightKeyboard(parent, t[10], keysize, DefaultSoftKeyboard.KEYTYPE_12KEY, isPortrait);

			k[DefaultSoftKeyboard.NICO_SLIDE_MODE_TOP][1]   = new MyHeightKeyboard(parent, t[11], keysize, DefaultSoftKeyboard.KEYTYPE_12KEY, isPortrait);
			k[DefaultSoftKeyboard.NICO_SLIDE_MODE_A][1]     = new MyHeightKeyboard(parent, t[12], keysize, DefaultSoftKeyboard.KEYTYPE_12KEY, isPortrait);
			k[DefaultSoftKeyboard.NICO_SLIDE_MODE_K][1]     = new MyHeightKeyboard(parent, t[13], keysize, DefaultSoftKeyboard.KEYTYPE_12KEY, isPortrait);
			k[DefaultSoftKeyboard.NICO_SLIDE_MODE_S][1]     = new MyHeightKeyboard(parent, t[14], keysize, DefaultSoftKeyboard.KEYTYPE_12KEY, isPortrait);
			k[DefaultSoftKeyboard.NICO_SLIDE_MODE_T][1]     = new MyHeightKeyboard(parent, t[15], keysize, DefaultSoftKeyboard.KEYTYPE_12KEY, isPortrait);
			k[DefaultSoftKeyboard.NICO_SLIDE_MODE_N][1]     = new MyHeightKeyboard(parent, t[16], keysize, DefaultSoftKeyboard.KEYTYPE_12KEY, isPortrait);
			k[DefaultSoftKeyboard.NICO_SLIDE_MODE_H][1]     = new MyHeightKeyboard(parent, t[17], keysize, DefaultSoftKeyboard.KEYTYPE_12KEY, isPortrait);
			k[DefaultSoftKeyboard.NICO_SLIDE_MODE_M][1]     = new MyHeightKeyboard(parent, t[18], keysize, DefaultSoftKeyboard.KEYTYPE_12KEY, isPortrait);
			k[DefaultSoftKeyboard.NICO_SLIDE_MODE_Y][1]     = new MyHeightKeyboard(parent, t[19], keysize, DefaultSoftKeyboard.KEYTYPE_12KEY, isPortrait);
			k[DefaultSoftKeyboard.NICO_SLIDE_MODE_R][1]     = new MyHeightKeyboard(parent, t[20], keysize, DefaultSoftKeyboard.KEYTYPE_12KEY, isPortrait);
			k[DefaultSoftKeyboard.NICO_SLIDE_MODE_W][1]     = new MyHeightKeyboard(parent, t[21], keysize, DefaultSoftKeyboard.KEYTYPE_12KEY, isPortrait);

			k = nicokeyboard[DefaultSoftKeyboard.NICO_MODE_FULL_KATAKANA];
			k[DefaultSoftKeyboard.NICO_SLIDE_MODE_TOP][0]   = new MyHeightKeyboard(parent, t[22], keysize, DefaultSoftKeyboard.KEYTYPE_12KEY, isPortrait);
			k[DefaultSoftKeyboard.NICO_SLIDE_MODE_A][0]     = new MyHeightKeyboard(parent, t[23], keysize, DefaultSoftKeyboard.KEYTYPE_12KEY, isPortrait);
			k[DefaultSoftKeyboard.NICO_SLIDE_MODE_K][0]     = new MyHeightKeyboard(parent, t[24], keysize, DefaultSoftKeyboard.KEYTYPE_12KEY, isPortrait);
			k[DefaultSoftKeyboard.NICO_SLIDE_MODE_S][0]     = new MyHeightKeyboard(parent, t[25], keysize, DefaultSoftKeyboard.KEYTYPE_12KEY, isPortrait);
			k[DefaultSoftKeyboard.NICO_SLIDE_MODE_T][0]     = new MyHeightKeyboard(parent, t[26], keysize, DefaultSoftKeyboard.KEYTYPE_12KEY, isPortrait);
			k[DefaultSoftKeyboard.NICO_SLIDE_MODE_N][0]     = new MyHeightKeyboard(parent, t[27], keysize, DefaultSoftKeyboard.KEYTYPE_12KEY, isPortrait);
			k[DefaultSoftKeyboard.NICO_SLIDE_MODE_H][0]     = new MyHeightKeyboard(parent, t[28], keysize, DefaultSoftKeyboard.KEYTYPE_12KEY, isPortrait);
			k[DefaultSoftKeyboard.NICO_SLIDE_MODE_M][0]     = new MyHeightKeyboard(parent, t[29], keysize, DefaultSoftKeyboard.KEYTYPE_12KEY, isPortrait);
			k[DefaultSoftKeyboard.NICO_SLIDE_MODE_Y][0]     = new MyHeightKeyboard(parent, t[30], keysize, DefaultSoftKeyboard.KEYTYPE_12KEY, isPortrait);
			k[DefaultSoftKeyboard.NICO_SLIDE_MODE_R][0]     = new MyHeightKeyboard(parent, t[31], keysize, DefaultSoftKeyboard.KEYTYPE_12KEY, isPortrait);
			k[DefaultSoftKeyboard.NICO_SLIDE_MODE_W][0]     = new MyHeightKeyboard(parent, t[32], keysize, DefaultSoftKeyboard.KEYTYPE_12KEY, isPortrait);

			k[DefaultSoftKeyboard.NICO_SLIDE_MODE_TOP][1]   = new MyHeightKeyboard(parent, t[33], keysize, DefaultSoftKeyboard.KEYTYPE_12KEY, isPortrait);
			k[DefaultSoftKeyboard.NICO_SLIDE_MODE_A][1]     = new MyHeightKeyboard(parent, t[34], keysize, DefaultSoftKeyboard.KEYTYPE_12KEY, isPortrait);
			k[DefaultSoftKeyboard.NICO_SLIDE_MODE_K][1]     = new MyHeightKeyboard(parent, t[35], keysize, DefaultSoftKeyboard.KEYTYPE_12KEY, isPortrait);
			k[DefaultSoftKeyboard.NICO_SLIDE_MODE_S][1]     = new MyHeightKeyboard(parent, t[36], keysize, DefaultSoftKeyboard.KEYTYPE_12KEY, isPortrait);
			k[DefaultSoftKeyboard.NICO_SLIDE_MODE_T][1]     = new MyHeightKeyboard(parent, t[37], keysize, DefaultSoftKeyboard.KEYTYPE_12KEY, isPortrait);
			k[DefaultSoftKeyboard.NICO_SLIDE_MODE_N][1]     = new MyHeightKeyboard(parent, t[38], keysize, DefaultSoftKeyboard.KEYTYPE_12KEY, isPortrait);
			k[DefaultSoftKeyboard.NICO_SLIDE_MODE_H][1]     = new MyHeightKeyboard(parent, t[39], keysize, DefaultSoftKeyboard.KEYTYPE_12KEY, isPortrait);
			k[DefaultSoftKeyboard.NICO_SLIDE_MODE_M][1]     = new MyHeightKeyboard(parent, t[40], keysize, DefaultSoftKeyboard.KEYTYPE_12KEY, isPortrait);
			k[DefaultSoftKeyboard.NICO_SLIDE_MODE_Y][1]     = new MyHeightKeyboard(parent, t[41], keysize, DefaultSoftKeyboard.KEYTYPE_12KEY, isPortrait);
			k[DefaultSoftKeyboard.NICO_SLIDE_MODE_R][1]     = new MyHeightKeyboard(parent, t[42], keysize, DefaultSoftKeyboard.KEYTYPE_12KEY, isPortrait);
			k[DefaultSoftKeyboard.NICO_SLIDE_MODE_W][1]     = new MyHeightKeyboard(parent, t[43], keysize, DefaultSoftKeyboard.KEYTYPE_12KEY, isPortrait);

			k = nicokeyboard[DefaultSoftKeyboard.NICO_MODE_HALF_KATAKANA];
			k[DefaultSoftKeyboard.NICO_SLIDE_MODE_TOP][0]   = new MyHeightKeyboard(parent, t[44], keysize, DefaultSoftKeyboard.KEYTYPE_12KEY, isPortrait);
			k[DefaultSoftKeyboard.NICO_SLIDE_MODE_A][0]     = new MyHeightKeyboard(parent, t[45], keysize, DefaultSoftKeyboard.KEYTYPE_12KEY, isPortrait);
			k[DefaultSoftKeyboard.NICO_SLIDE_MODE_K][0]     = new MyHeightKeyboard(parent, t[46], keysize, DefaultSoftKeyboard.KEYTYPE_12KEY, isPortrait);
			k[DefaultSoftKeyboard.NICO_SLIDE_MODE_S][0]     = new MyHeightKeyboard(parent, t[47], keysize, DefaultSoftKeyboard.KEYTYPE_12KEY, isPortrait);
			k[DefaultSoftKeyboard.NICO_SLIDE_MODE_T][0]     = new MyHeightKeyboard(parent, t[48], keysize, DefaultSoftKeyboard.KEYTYPE_12KEY, isPortrait);
			k[DefaultSoftKeyboard.NICO_SLIDE_MODE_N][0]     = new MyHeightKeyboard(parent, t[49], keysize, DefaultSoftKeyboard.KEYTYPE_12KEY, isPortrait);
			k[DefaultSoftKeyboard.NICO_SLIDE_MODE_H][0]     = new MyHeightKeyboard(parent, t[50], keysize, DefaultSoftKeyboard.KEYTYPE_12KEY, isPortrait);
			k[DefaultSoftKeyboard.NICO_SLIDE_MODE_M][0]     = new MyHeightKeyboard(parent, t[51], keysize, DefaultSoftKeyboard.KEYTYPE_12KEY, isPortrait);
			k[DefaultSoftKeyboard.NICO_SLIDE_MODE_Y][0]     = new MyHeightKeyboard(parent, t[52], keysize, DefaultSoftKeyboard.KEYTYPE_12KEY, isPortrait);
			k[DefaultSoftKeyboard.NICO_SLIDE_MODE_R][0]     = new MyHeightKeyboard(parent, t[53], keysize, DefaultSoftKeyboard.KEYTYPE_12KEY, isPortrait);
			k[DefaultSoftKeyboard.NICO_SLIDE_MODE_W][0]     = new MyHeightKeyboard(parent, t[54], keysize, DefaultSoftKeyboard.KEYTYPE_12KEY, isPortrait);

			k[DefaultSoftKeyboard.NICO_SLIDE_MODE_TOP][1]   = new MyHeightKeyboard(parent, t[55], keysize, DefaultSoftKeyboard.KEYTYPE_12KEY, isPortrait);
			k[DefaultSoftKeyboard.NICO_SLIDE_MODE_A][1]     = new MyHeightKeyboard(parent, t[56], keysize, DefaultSoftKeyboard.KEYTYPE_12KEY, isPortrait);
			k[DefaultSoftKeyboard.NICO_SLIDE_MODE_K][1]     = new MyHeightKeyboard(parent, t[57], keysize, DefaultSoftKeyboard.KEYTYPE_12KEY, isPortrait);
			k[DefaultSoftKeyboard.NICO_SLIDE_MODE_S][1]     = new MyHeightKeyboard(parent, t[58], keysize, DefaultSoftKeyboard.KEYTYPE_12KEY, isPortrait);
			k[DefaultSoftKeyboard.NICO_SLIDE_MODE_T][1]     = new MyHeightKeyboard(parent, t[59], keysize, DefaultSoftKeyboard.KEYTYPE_12KEY, isPortrait);
			k[DefaultSoftKeyboard.NICO_SLIDE_MODE_N][1]     = new MyHeightKeyboard(parent, t[60], keysize, DefaultSoftKeyboard.KEYTYPE_12KEY, isPortrait);
			k[DefaultSoftKeyboard.NICO_SLIDE_MODE_H][1]     = new MyHeightKeyboard(parent, t[61], keysize, DefaultSoftKeyboard.KEYTYPE_12KEY, isPortrait);
			k[DefaultSoftKeyboard.NICO_SLIDE_MODE_M][1]     = new MyHeightKeyboard(parent, t[62], keysize, DefaultSoftKeyboard.KEYTYPE_12KEY, isPortrait);
			k[DefaultSoftKeyboard.NICO_SLIDE_MODE_Y][1]     = new MyHeightKeyboard(parent, t[63], keysize, DefaultSoftKeyboard.KEYTYPE_12KEY, isPortrait);
			k[DefaultSoftKeyboard.NICO_SLIDE_MODE_R][1]     = new MyHeightKeyboard(parent, t[64], keysize, DefaultSoftKeyboard.KEYTYPE_12KEY, isPortrait);
			k[DefaultSoftKeyboard.NICO_SLIDE_MODE_W][1]     = new MyHeightKeyboard(parent, t[65], keysize, DefaultSoftKeyboard.KEYTYPE_12KEY, isPortrait);
		}
		return nicokeyboard;
	}
	/*********************************
	 *
	 */
	public String[][][][] SetupCycleTable() {
		return JP_FULL_NICO_CYCLE_TABLE;
	}
	/*********************************
	 *
	 */
	public HashMap<String, String> SetupReplaceTable(final boolean du) {
		return (du ? JP_FULL_NICO_REPLACE_TABLE_2 : JP_FULL_NICO_REPLACE_TABLE_1);
	}
	/*********************************
	 *
	 */
	public int SetupIcon() {
		return R.drawable.immodeic_niko;
	}
	/*********************************
	 *
	 */
	public int GetFlickKeyCode(final int line, final int row) {
		return flickChangeMap[line][row];
	}



	/** Toggle cycle table for full-width Nicotouch */
	public static final String[][][][] JP_FULL_NICO_CYCLE_TABLE = {
		{
			{
				{"\u3042"}, {"\u3044"}, {"\u3046"}, {"\u3048"}, {"\u304a"},      {"."},      {"-"},      {"@"},      {"_"}, {"1"},
				{"\u304b"}, {"\u304d"}, {"\u304f"}, {"\u3051"}, {"\u3053"},      {" "},      {"a"},      {"b"},      {"c"}, {"2"},
				{"\u3055"}, {"\u3057"}, {"\u3059"}, {"\u305b"}, {"\u305d"},      {"/"},      {"d"},      {"e"},      {"f"}, {"3"},
				{"\u305f"}, {"\u3061"}, {"\u3064"}, {"\u3066"}, {"\u3068"}, {"\u3063"},      {"g"},      {"h"},      {"i"}, {"4"},
				{"\u306a"}, {"\u306b"}, {"\u306c"}, {"\u306d"}, {"\u306e"},      {"("},      {"j"},      {"k"},      {"l"}, {"5"},
				{"\u306f"}, {"\u3072"}, {"\u3075"}, {"\u3078"}, {"\u307b"},      {")"},      {"m"},      {"n"},      {"o"}, {"6"},
				{"\u307e"}, {"\u307f"}, {"\u3080"}, {"\u3081"}, {"\u3082"},      {"p"},      {"q"},      {"r"},      {"s"}, {"7"},
				{"\u3084"}, {"\u3086"}, {"\u3088"}, {"\u3083"}, {"\u3085"}, {"\u3087"},      {"t"},      {"u"},      {"v"}, {"8"},
				{"\u3089"}, {"\u308a"}, {"\u308b"}, {"\u308c"}, {"\u308d"},      {"w"},      {"x"},      {"y"},      {"z"}, {"9"},
				{"\u308f"}, {"\u3092"}, {"\u3093"}, {"\u3001"}, {"\u3002"}, {"\u30fc"}, {"\u30fb"}, {"\uff01"}, {"\uff1f"}, {"0"},
			},
			{
				{"\u3042"}, {"\u3044"}, {"\u3046"}, {"\u3048"}, {"\u304a"},      {"."},      {"-"},      {"@"},      {"_"}, {"1"},
				{"\u304b"}, {"\u304d"}, {"\u304f"}, {"\u3051"}, {"\u3053"},      {" "},      {"A"},      {"B"},      {"C"}, {"2"},
				{"\u3055"}, {"\u3057"}, {"\u3059"}, {"\u305b"}, {"\u305d"},      {"/"},      {"D"},      {"E"},      {"F"}, {"3"},
				{"\u305f"}, {"\u3061"}, {"\u3064"}, {"\u3066"}, {"\u3068"}, {"\u3063"},      {"G"},      {"H"},      {"I"}, {"4"},
				{"\u306a"}, {"\u306b"}, {"\u306c"}, {"\u306d"}, {"\u306e"},      {"("},      {"J"},      {"K"},      {"L"}, {"5"},
				{"\u306f"}, {"\u3072"}, {"\u3075"}, {"\u3078"}, {"\u307b"},      {")"},      {"M"},      {"N"},      {"O"}, {"6"},
				{"\u307e"}, {"\u307f"}, {"\u3080"}, {"\u3081"}, {"\u3082"},      {"P"},      {"Q"},      {"R"},      {"S"}, {"7"},
				{"\u3084"}, {"\u3086"}, {"\u3088"}, {"\u3083"}, {"\u3085"}, {"\u3087"},      {"T"},      {"U"},      {"V"}, {"8"},
				{"\u3089"}, {"\u308a"}, {"\u308b"}, {"\u308c"}, {"\u308d"},      {"W"},      {"X"},      {"Y"},      {"Z"}, {"9"},
				{"\u308f"}, {"\u3092"}, {"\u3093"}, {"\u3001"}, {"\u3002"}, {"\u30fc"}, {"\u30fb"}, {"\uff01"}, {"\uff1f"}, {"0"},
			}
		},
		{
			{
				{"\u30a2"}, {"\u30a4"}, {"\u30a6"}, {"\u30a8"}, {"\u30aa"},      {"."},      {"-"},      {"@"},      {"_"}, {"1"},
				{"\u30ab"}, {"\u30ad"}, {"\u30af"}, {"\u30b1"}, {"\u30b3"},      {" "},      {"a"},      {"b"},      {"c"}, {"2"},
				{"\u30b5"}, {"\u30b7"}, {"\u30b9"}, {"\u30bb"}, {"\u30bd"},      {"/"},      {"d"},      {"e"},      {"f"}, {"3"},
				{"\u30bf"}, {"\u30c1"}, {"\u30c4"}, {"\u30c6"}, {"\u30c8"}, {"\u30c3"},      {"g"},      {"h"},      {"i"}, {"4"},
				{"\u30ca"}, {"\u30cb"}, {"\u30cc"}, {"\u30cd"}, {"\u30ce"},      {"("},      {"j"},      {"k"},      {"l"}, {"5"},
				{"\u30cf"}, {"\u30d2"}, {"\u30d5"}, {"\u30d8"}, {"\u30db"},      {")"},      {"m"},      {"n"},      {"o"}, {"6"},
				{"\u30de"}, {"\u30df"}, {"\u30e0"}, {"\u30e1"}, {"\u30e2"},      {"p"},      {"q"},      {"r"},      {"s"}, {"7"},
				{"\u30e4"}, {"\u30e6"}, {"\u30e8"}, {"\u30e3"}, {"\u30e5"}, {"\u30e7"},      {"t"},      {"u"},      {"v"}, {"8"},
				{"\u30e9"}, {"\u30ea"}, {"\u30eb"}, {"\u30ec"}, {"\u30ed"},      {"w"},      {"x"},      {"y"},      {"z"}, {"9"},
				{"\u30ef"}, {"\u30f2"}, {"\u30f3"}, {"\u3001"}, {"\u3002"}, {"\u30fc"}, {"\u30fb"}, {"\uff01"}, {"\uff1f"}, {"0"},
			},
			{
				{"\u30a2"}, {"\u30a4"}, {"\u30a6"}, {"\u30a8"}, {"\u30aa"},      {"."},      {"-"},      {"@"},      {"_"}, {"1"},
				{"\u30ab"}, {"\u30ad"}, {"\u30af"}, {"\u30b1"}, {"\u30b3"},      {" "},      {"A"},      {"B"},      {"C"}, {"2"},
				{"\u30b5"}, {"\u30b7"}, {"\u30b9"}, {"\u30bb"}, {"\u30bd"},      {"/"},      {"D"},      {"E"},      {"F"}, {"3"},
				{"\u30bf"}, {"\u30c1"}, {"\u30c4"}, {"\u30c6"}, {"\u30c8"}, {"\u30c3"},      {"G"},      {"H"},      {"I"}, {"4"},
				{"\u30ca"}, {"\u30cb"}, {"\u30cc"}, {"\u30cd"}, {"\u30ce"},      {"("},      {"J"},      {"K"},      {"L"}, {"5"},
				{"\u30cf"}, {"\u30d2"}, {"\u30d5"}, {"\u30d8"}, {"\u30db"},      {")"},      {"M"},      {"N"},      {"O"}, {"6"},
				{"\u30de"}, {"\u30df"}, {"\u30e0"}, {"\u30e1"}, {"\u30e2"},      {"P"},      {"Q"},      {"R"},      {"S"}, {"7"},
				{"\u30e4"}, {"\u30e6"}, {"\u30e8"}, {"\u30e3"}, {"\u30e5"}, {"\u30e7"},      {"T"},      {"U"},      {"V"}, {"8"},
				{"\u30e9"}, {"\u30ea"}, {"\u30eb"}, {"\u30ec"}, {"\u30ed"},      {"W"},      {"X"},      {"Y"},      {"Z"}, {"9"},
				{"\u30ef"}, {"\u30f2"}, {"\u30f3"}, {"\u3001"}, {"\u3002"}, {"\u30fc"}, {"\u30fb"}, {"\uff01"}, {"\uff1f"}, {"0"},
			}
		},
		{
			{
				{"\uff71"}, {"\uff72"}, {"\uff73"}, {"\uff74"}, {"\uff75"},      {"."},      {"-"},      {"@"},      {"_"}, {"1"},
				{"\uff76"}, {"\uff77"}, {"\uff78"}, {"\uff79"}, {"\uff7a"},      {" "},      {"a"},      {"b"},      {"c"}, {"2"},
				{"\uff7b"}, {"\uff7c"}, {"\uff7d"}, {"\uff7e"}, {"\uff7f"},      {"/"},      {"d"},      {"e"},      {"f"}, {"3"},
				{"\uff80"}, {"\uff81"}, {"\uff82"}, {"\uff83"}, {"\uff84"}, {"\uff6f"},      {"g"},      {"h"},      {"i"}, {"4"},
				{"\uff85"}, {"\uff86"}, {"\uff87"}, {"\uff88"}, {"\uff89"},      {"("},      {"j"},      {"k"},      {"l"}, {"5"},
				{"\uff8a"}, {"\uff8b"}, {"\uff8c"}, {"\uff8d"}, {"\uff8e"},      {")"},      {"m"},      {"n"},      {"o"}, {"6"},
				{"\uff8f"}, {"\uff90"}, {"\uff91"}, {"\uff92"}, {"\uff93"},      {"p"},      {"q"},      {"r"},      {"s"}, {"7"},
				{"\uff94"}, {"\uff95"}, {"\uff96"}, {"\uff6c"}, {"\uff6d"}, {"\uff6e"},      {"t"},      {"u"},      {"v"}, {"8"},
				{"\uff97"}, {"\uff98"}, {"\uff99"}, {"\uff9a"}, {"\uff9b"},      {"w"},      {"x"},      {"y"},      {"z"}, {"9"},
				{"\uff9c"}, {"\uff66"}, {"\uff9d"}, {"\uff64"}, {"\uff61"}, {"\uff70"}, {"\uff65"}, {"\uff01"}, {"\uff1f"}, {"0"},
			},
			{
				{"\uff71"}, {"\uff72"}, {"\uff73"}, {"\uff74"}, {"\uff75"},      {"."},      {"-"},      {"@"},      {"_"}, {"1"},
				{"\uff76"}, {"\uff77"}, {"\uff78"}, {"\uff79"}, {"\uff7a"},      {" "},      {"A"},      {"B"},      {"C"}, {"2"},
				{"\uff7b"}, {"\uff7c"}, {"\uff7d"}, {"\uff7e"}, {"\uff7f"},      {"/"},      {"D"},      {"E"},      {"F"}, {"3"},
				{"\uff80"}, {"\uff81"}, {"\uff82"}, {"\uff83"}, {"\uff84"}, {"\uff6f"},      {"G"},      {"H"},      {"I"}, {"4"},
				{"\uff85"}, {"\uff86"}, {"\uff87"}, {"\uff88"}, {"\uff89"},      {"("},      {"J"},      {"K"},      {"L"}, {"5"},
				{"\uff8a"}, {"\uff8b"}, {"\uff8c"}, {"\uff8d"}, {"\uff8e"},      {")"},      {"M"},      {"N"},      {"O"}, {"6"},
				{"\uff8f"}, {"\uff90"}, {"\uff91"}, {"\uff92"}, {"\uff93"},      {"P"},      {"Q"},      {"R"},      {"S"}, {"7"},
				{"\uff94"}, {"\uff95"}, {"\uff96"}, {"\uff6c"}, {"\uff6d"}, {"\uff6e"},      {"T"},      {"U"},      {"V"}, {"8"},
				{"\uff97"}, {"\uff98"}, {"\uff99"}, {"\uff9a"}, {"\uff9b"},      {"W"},      {"X"},      {"Y"},      {"Z"}, {"9"},
				{"\uff9c"}, {"\uff66"}, {"\uff9d"}, {"\uff64"}, {"\uff61"}, {"\uff70"}, {"\uff65"}, {"\uff01"}, {"\uff1f"}, {"0"},
			}
		},
	};

	/** Replace table for full-width Nicotouch */
	public static final HashMap<String, String> JP_FULL_NICO_REPLACE_TABLE_1 = new HashMap<String, String>() {
		/**
		 *
		 */
		private static final long serialVersionUID = 1L;

		{
			put("\u3042", "\u3041"); put("\u3044", "\u3043"); put("\u3046", "\u3045"); put("\u3048", "\u3047"); put("\u304a", "\u3049"); // A
			put("\u3041", "\u3042"); put("\u3043", "\u3044"); put("\u3045", "\u30f4"); put("\u3047", "\u3048"); put("\u3049", "\u304a"); // a
			put("\u304b", "\u304c"); put("\u304d", "\u304e"); put("\u304f", "\u3050"); put("\u3051", "\u3052"); put("\u3053", "\u3054"); // K
			put("\u304c", "\u304b"); put("\u304e", "\u304d"); put("\u3050", "\u304f"); put("\u3052", "\u3051"); put("\u3054", "\u3053"); // k
			put("\u3055", "\u3056"); put("\u3057", "\u3058"); put("\u3059", "\u305a"); put("\u305b", "\u305c"); put("\u305d", "\u305e"); // S
			put("\u3056", "\u3055"); put("\u3058", "\u3057"); put("\u305a", "\u3059"); put("\u305c", "\u305b"); put("\u305e", "\u305d"); // s
			put("\u305f", "\u3060"); put("\u3061", "\u3062"); put("\u3064", "\u3063"); put("\u3066", "\u3067"); put("\u3068", "\u3069"); // T
			put("\u3060", "\u305f"); put("\u3062", "\u3061"); put("\u3063", "\u3065"); put("\u3067", "\u3066"); put("\u3069", "\u3068"); // t
			put("\u3065", "\u3064"); // du
			put("\u30f4", "\u3046"); // vu
			put("\u306f", "\u3070"); put("\u3072", "\u3073"); put("\u3075", "\u3076"); put("\u3078", "\u3079"); put("\u307b", "\u307c"); // H
			put("\u3070", "\u3071"); put("\u3073", "\u3074"); put("\u3076", "\u3077"); put("\u3079", "\u307a"); put("\u307c", "\u307d"); // h
			put("\u3071", "\u306f"); put("\u3074", "\u3072"); put("\u3077", "\u3075"); put("\u307a", "\u3078"); put("\u307d", "\u307b"); // h.
			put("\u3084", "\u3083"); put("\u3086", "\u3085"); put("\u3088", "\u3087"); // Y
			put("\u3083", "\u3084"); put("\u3085", "\u3086"); put("\u3087", "\u3088"); // y
			put("\u308f", "\u308e"); put("\u308e", "\u308f"); // W
			put("\u309b", "\u309c"); put("\u309c", "\u309b"); // dakuten

			put("\u30a2", "\u30a1"); put("\u30a4", "\u30a3"); put("\u30a6", "\u30a5"); put("\u30a8", "\u30a7"); put("\u30aa", "\u30a9"); // A
			put("\u30a1", "\u30a2"); put("\u30a3", "\u30a4"); put("\u30a5", "\u30f4"); put("\u30a7", "\u30a8"); put("\u30a9", "\u30aa"); // a
			put("\u30ab", "\u30ac"); put("\u30ad", "\u30ae"); put("\u30af", "\u30b0"); put("\u30b1", "\u30b2"); put("\u30b3", "\u30b4"); // K
			put("\u30ac", "\u30ab"); put("\u30ae", "\u30ad"); put("\u30b0", "\u30af"); put("\u30b2", "\u30b1"); put("\u30b4", "\u30b3"); // k
			put("\u30b5", "\u30b6"); put("\u30b7", "\u30b8"); put("\u30b9", "\u30ba"); put("\u30bb", "\u30bc"); put("\u30bd", "\u30be"); // S
			put("\u30b6", "\u30b5"); put("\u30b8", "\u30b7"); put("\u30ba", "\u30b9"); put("\u30bc", "\u30bb"); put("\u30be", "\u30bd"); // s
			put("\u30bf", "\u30c0"); put("\u30c1", "\u30c2"); put("\u30c4", "\u30c3"); put("\u30c6", "\u30c7"); put("\u30c8", "\u30c9"); // T
			put("\u30c0", "\u30bf"); put("\u30c2", "\u30c1"); put("\u30c3", "\u30c5"); put("\u30c7", "\u30c6"); put("\u30c9", "\u30c8"); // t
			put("\u30c5", "\u30c4"); // du
			put("\u30f4", "\u30a6"); // vu
			put("\u30cf", "\u30d0"); put("\u30d2", "\u30d3"); put("\u30d5", "\u30d6"); put("\u30d8", "\u30d9"); put("\u30db", "\u30dc"); // H
			put("\u30d0", "\u30d1"); put("\u30d3", "\u30d4"); put("\u30d6", "\u30d7"); put("\u30d9", "\u30da"); put("\u30dc", "\u30dd"); // h
			put("\u30d1", "\u30cf"); put("\u30d4", "\u30d2"); put("\u30d7", "\u30d5"); put("\u30da", "\u30d8"); put("\u30dd", "\u30db"); // h.
			put("\u30e4", "\u30e3"); put("\u30e6", "\u30e5"); put("\u30e8", "\u30e7"); // Y
			put("\u30e3", "\u30e4"); put("\u30e5", "\u30e6"); put("\u30e7", "\u30e8"); // y
			put("\u30ef", "\u30ee"); put("\u30ee", "\u30ef"); // W
			put("\u309b", "\u309c"); put("\u309c", "\u309b"); // dakuten

			put("\uff71", "\uff67"); put("\uff72", "\uff68"); put("\uff73", "\uff69"); put("\uff74", "\uff6a"); put("\uff75", "\uff6b"); // A
			put("\uff67", "\uff71"); put("\uff68", "\uff72"); put("\uff69", "\uff73"); put("\uff6a", "\uff74"); put("\uff6b", "\uff75"); // a
			put("\uff82", "\uff6f"); put("\uff6f", "\uff82"); // tu
			put("\uff94", "\uff6c"); put("\uff95", "\uff6d"); put("\uff96", "\uff6e"); // Y
			put("\uff6c", "\uff94"); put("\uff6d", "\uff95"); put("\uff6e", "\uff96"); // y
			put("\uff9e", "\uff9f"); put("\uff9f", "\uff9e"); // dakuten

			put("a", "A"); put("b", "B"); put("c", "C"); put("d", "D"); put("e", "E"); put("f", "F"); put("g", "G"); put("h", "H"); put("i", "I"); put("j", "J");
			put("k", "K"); put("l", "L"); put("m", "M"); put("n", "N"); put("o", "O"); put("p", "P"); put("q", "Q"); put("r", "R"); put("s", "S"); put("t", "T");
			put("u", "U"); put("v", "V"); put("w", "W"); put("x", "X"); put("y", "Y"); put("z", "Z");
			put("A", "a"); put("B", "b"); put("C", "c"); put("D", "d"); put("E", "e"); put("F", "f"); put("G", "g"); put("H", "h"); put("I", "i"); put("J", "j");
			put("K", "k"); put("L", "l"); put("M", "m"); put("N", "n"); put("O", "o"); put("P", "p"); put("Q", "q"); put("R", "r"); put("S", "s"); put("T", "t");
			put("U", "u"); put("V", "v"); put("W", "w"); put("X", "x"); put("Y", "y"); put("Z", "z");

			put("1", "\uff11"); put("2", "\uff12"); put("3", "\uff13"); put("4", "\uff14"); put("5", "\uff15");
			put("6", "\uff16"); put("7", "\uff17"); put("8", "\uff18"); put("9", "\uff19"); put("0", "\uff10");
			put("\uff11", "1"); put("\uff12", "2"); put("\uff13", "3"); put("\uff14", "4"); put("\uff15", "5");
			put("\uff16", "6"); put("\uff17", "7"); put("\uff18", "8"); put("\uff19", "9"); put("\uff10", "0");

			put(".", "\uff0e"); put("-", "\u2015"); put("@", "\uff20"); put("_", "\uff3f");
			put("\uff0e", "."); put("\u2015", "-"); put("\uff20", "@"); put("\uff3f", "_");

			put("\uff01", "!"); put("\uff1f", "?");
			put("!", "\uff01"); put("?", "\uff1f");

			put("\u3000", " "); put(" ", "\u3000");

			put("(", "["); put("[", "\u300c"); put("\u300c", "\u300e"); put("\u300e", "\u3010"); put("\u3010", "(");
			put(")", "]"); put("]", "\u300d"); put("\u300d", "\u300f"); put("\u300f", "\u3011"); put("\u3011", ")");
		}
	};

	public static final HashMap<String, String> JP_FULL_NICO_REPLACE_TABLE_2 = new HashMap<String, String>() {
		/**
		 *
		 */
		private static final long serialVersionUID = 1L;

		{
			put("\u3042", "\u3041"); put("\u3044", "\u3043"); put("\u3046", "\u3045"); put("\u3048", "\u3047"); put("\u304a", "\u3049"); // A
			put("\u3041", "\u3042"); put("\u3043", "\u3044"); put("\u3045", "\u30f4"); put("\u3047", "\u3048"); put("\u3049", "\u304a"); // a
			put("\u304b", "\u304c"); put("\u304d", "\u304e"); put("\u304f", "\u3050"); put("\u3051", "\u3052"); put("\u3053", "\u3054"); // K
			put("\u304c", "\u304b"); put("\u304e", "\u304d"); put("\u3050", "\u304f"); put("\u3052", "\u3051"); put("\u3054", "\u3053"); // k
			put("\u3055", "\u3056"); put("\u3057", "\u3058"); put("\u3059", "\u305a"); put("\u305b", "\u305c"); put("\u305d", "\u305e"); // S
			put("\u3056", "\u3055"); put("\u3058", "\u3057"); put("\u305a", "\u3059"); put("\u305c", "\u305b"); put("\u305e", "\u305d"); // s
			put("\u305f", "\u3060"); put("\u3061", "\u3062"); put("\u3064", "\u3065"); put("\u3066", "\u3067"); put("\u3068", "\u3069"); // T
			put("\u3060", "\u305f"); put("\u3062", "\u3061"); put("\u3065", "\u3063"); put("\u3067", "\u3066"); put("\u3069", "\u3068"); // t
			put("\u3063", "\u3064"); // ltu
			put("\u30f4", "\u3046"); // vu
			put("\u306f", "\u3070"); put("\u3072", "\u3073"); put("\u3075", "\u3076"); put("\u3078", "\u3079"); put("\u307b", "\u307c"); // H
			put("\u3070", "\u3071"); put("\u3073", "\u3074"); put("\u3076", "\u3077"); put("\u3079", "\u307a"); put("\u307c", "\u307d"); // h
			put("\u3071", "\u306f"); put("\u3074", "\u3072"); put("\u3077", "\u3075"); put("\u307a", "\u3078"); put("\u307d", "\u307b"); // h.
			put("\u3084", "\u3083"); put("\u3086", "\u3085"); put("\u3088", "\u3087"); // Y
			put("\u3083", "\u3084"); put("\u3085", "\u3086"); put("\u3087", "\u3088"); // y
			put("\u308f", "\u308e"); put("\u308e", "\u308f"); // W
			put("\u309b", "\u309c"); put("\u309c", "\u309b"); // dakuten

			put("\u30a2", "\u30a1"); put("\u30a4", "\u30a3"); put("\u30a6", "\u30a5"); put("\u30a8", "\u30a7"); put("\u30aa", "\u30a9"); // A
			put("\u30a1", "\u30a2"); put("\u30a3", "\u30a4"); put("\u30a5", "\u30f4"); put("\u30a7", "\u30a8"); put("\u30a9", "\u30aa"); // a
			put("\u30ab", "\u30ac"); put("\u30ad", "\u30ae"); put("\u30af", "\u30b0"); put("\u30b1", "\u30b2"); put("\u30b3", "\u30b4"); // K
			put("\u30ac", "\u30ab"); put("\u30ae", "\u30ad"); put("\u30b0", "\u30af"); put("\u30b2", "\u30b1"); put("\u30b4", "\u30b3"); // k
			put("\u30b5", "\u30b6"); put("\u30b7", "\u30b8"); put("\u30b9", "\u30ba"); put("\u30bb", "\u30bc"); put("\u30bd", "\u30be"); // S
			put("\u30b6", "\u30b5"); put("\u30b8", "\u30b7"); put("\u30ba", "\u30b9"); put("\u30bc", "\u30bb"); put("\u30be", "\u30bd"); // s
			put("\u30bf", "\u30c0"); put("\u30c1", "\u30c2"); put("\u30c4", "\u30c5"); put("\u30c6", "\u30c7"); put("\u30c8", "\u30c9"); // T
			put("\u30c0", "\u30bf"); put("\u30c2", "\u30c1"); put("\u30c5", "\u30c3"); put("\u30c7", "\u30c6"); put("\u30c9", "\u30c8"); // t
			put("\u30c3", "\u30c4"); // ltu
			put("\u30f4", "\u30a6"); // vu
			put("\u30cf", "\u30d0"); put("\u30d2", "\u30d3"); put("\u30d5", "\u30d6"); put("\u30d8", "\u30d9"); put("\u30db", "\u30dc"); // H
			put("\u30d0", "\u30d1"); put("\u30d3", "\u30d4"); put("\u30d6", "\u30d7"); put("\u30d9", "\u30da"); put("\u30dc", "\u30dd"); // h
			put("\u30d1", "\u30cf"); put("\u30d4", "\u30d2"); put("\u30d7", "\u30d5"); put("\u30da", "\u30d8"); put("\u30dd", "\u30db"); // h.
			put("\u30e4", "\u30e3"); put("\u30e6", "\u30e5"); put("\u30e8", "\u30e7"); // Y
			put("\u30e3", "\u30e4"); put("\u30e5", "\u30e6"); put("\u30e7", "\u30e8"); // y
			put("\u30ef", "\u30ee"); put("\u30ee", "\u30ef"); // W
			put("\u309b", "\u309c"); put("\u309c", "\u309b"); // dakuten

			put("\uff71", "\uff67"); put("\uff72", "\uff68"); put("\uff73", "\uff69"); put("\uff74", "\uff6a"); put("\uff75", "\uff6b"); // A
			put("\uff67", "\uff71"); put("\uff68", "\uff72"); put("\uff69", "\uff73"); put("\uff6a", "\uff74"); put("\uff6b", "\uff75"); // a
			put("\uff82", "\uff6f"); put("\uff6f", "\uff82"); // tu
			put("\uff94", "\uff6c"); put("\uff95", "\uff6d"); put("\uff96", "\uff6e"); // Y
			put("\uff6c", "\uff94"); put("\uff6d", "\uff95"); put("\uff6e", "\uff96"); // y
			put("\uff9e", "\uff9f"); put("\uff9f", "\uff9e"); // dakuten

			put("a", "A"); put("b", "B"); put("c", "C"); put("d", "D"); put("e", "E"); put("f", "F"); put("g", "G"); put("h", "H"); put("i", "I"); put("j", "J");
			put("k", "K"); put("l", "L"); put("m", "M"); put("n", "N"); put("o", "O"); put("p", "P"); put("q", "Q"); put("r", "R"); put("s", "S"); put("t", "T");
			put("u", "U"); put("v", "V"); put("w", "W"); put("x", "X"); put("y", "Y"); put("z", "Z");
			put("A", "a"); put("B", "b"); put("C", "c"); put("D", "d"); put("E", "e"); put("F", "f"); put("G", "g"); put("H", "h"); put("I", "i"); put("J", "j");
			put("K", "k"); put("L", "l"); put("M", "m"); put("N", "n"); put("O", "o"); put("P", "p"); put("Q", "q"); put("R", "r"); put("S", "s"); put("T", "t");
			put("U", "u"); put("V", "v"); put("W", "w"); put("X", "x"); put("Y", "y"); put("Z", "z");

			put("1", "\uff11"); put("2", "\uff12"); put("3", "\uff13"); put("4", "\uff14"); put("5", "\uff15");
			put("6", "\uff16"); put("7", "\uff17"); put("8", "\uff18"); put("9", "\uff19"); put("0", "\uff10");
			put("\uff11", "1"); put("\uff12", "2"); put("\uff13", "3"); put("\uff14", "4"); put("\uff15", "5");
			put("\uff16", "6"); put("\uff17", "7"); put("\uff18", "8"); put("\uff19", "9"); put("\uff10", "0");

			put(".", "\uff0e"); put("-", "\u2015"); put("@", "\uff20"); put("_", "\uff3f");
			put("\uff0e", "."); put("\u2015", "-"); put("\uff20", "@"); put("\uff3f", "_");

			put("\uff01", "!"); put("\uff1f", "?");
			put("!", "\uff01"); put("?", "\uff1f");

			put("\u3000", " "); put(" ", "\u3000");

			put("(", "["); put("[", "\u300c"); put("\u300c", "\u300e"); put("\u300e", "\u3010"); put("\u3010", "(");
			put(")", "]"); put("]", "\u300d"); put("\u300d", "\u300f"); put("\u300f", "\u3011"); put("\u3011", ")");
		}
	};

	/**
	 * change map
	 */
	public static final int flickChangeMap[][] = {
		{  0,  4,  1,  2,  3 }, // A
		{  0,  4,  1,  2,  3 }, // Ka
		{  0,  4,  1,  2,  3 }, // Sa
		{  0,  4,  1,  2,  3 }, // Ta
		{  0,  4,  1,  2,  3 }, // Na
		{  0,  4,  1,  2,  3 }, // Ha
		{  0,  4,  1,  2,  3 }, // Ma
		{  0,  2, -1,  1, -1 }, // Ya
		{  0,  4,  1,  2,  3 }, // Ra
		{  0, -1,  1,  2,  5 }, // Wa
	};

	private static int selectLandKeyTable[] = {
		R.xml.key_nico_top_0,
		R.xml.key_nico_a_0,
		R.xml.key_nico_k_0,
		R.xml.key_nico_s_0,
		R.xml.key_nico_t_0,
		R.xml.key_nico_n_0,
		R.xml.key_nico_h_0,
		R.xml.key_nico_m_0,
		R.xml.key_nico_y_0,
		R.xml.key_nico_r_0,
		R.xml.key_nico_w_0,
		R.xml.key_nico_input_top_0,
		R.xml.key_nico_input_a_0,
		R.xml.key_nico_input_k_0,
		R.xml.key_nico_input_s_0,
		R.xml.key_nico_input_t_0,
		R.xml.key_nico_input_n_0,
		R.xml.key_nico_input_h_0,
		R.xml.key_nico_input_m_0,
		R.xml.key_nico_input_y_0,
		R.xml.key_nico_input_r_0,
		R.xml.key_nico_input_w_0,

		R.xml.key_nico_katakana_full_top_0,
		R.xml.key_nico_katakana_full_a_0,
		R.xml.key_nico_katakana_full_k_0,
		R.xml.key_nico_katakana_full_s_0,
		R.xml.key_nico_katakana_full_t_0,
		R.xml.key_nico_katakana_full_n_0,
		R.xml.key_nico_katakana_full_h_0,
		R.xml.key_nico_katakana_full_m_0,
		R.xml.key_nico_katakana_full_y_0,
		R.xml.key_nico_katakana_full_r_0,
		R.xml.key_nico_katakana_full_w_0,
		R.xml.key_nico_katakana_full_input_top_0,
		R.xml.key_nico_katakana_full_input_a_0,
		R.xml.key_nico_katakana_full_input_k_0,
		R.xml.key_nico_katakana_full_input_s_0,
		R.xml.key_nico_katakana_full_input_t_0,
		R.xml.key_nico_katakana_full_input_n_0,
		R.xml.key_nico_katakana_full_input_h_0,
		R.xml.key_nico_katakana_full_input_m_0,
		R.xml.key_nico_katakana_full_input_y_0,
		R.xml.key_nico_katakana_full_input_r_0,
		R.xml.key_nico_katakana_full_input_w_0,

		R.xml.key_nico_katakana_half_top_0,
		R.xml.key_nico_katakana_half_a_0,
		R.xml.key_nico_katakana_half_k_0,
		R.xml.key_nico_katakana_half_s_0,
		R.xml.key_nico_katakana_half_t_0,
		R.xml.key_nico_katakana_half_n_0,
		R.xml.key_nico_katakana_half_h_0,
		R.xml.key_nico_katakana_half_m_0,
		R.xml.key_nico_katakana_half_y_0,
		R.xml.key_nico_katakana_half_r_0,
		R.xml.key_nico_katakana_half_w_0,
		R.xml.key_nico_katakana_half_input_top_0,
		R.xml.key_nico_katakana_half_input_a_0,
		R.xml.key_nico_katakana_half_input_k_0,
		R.xml.key_nico_katakana_half_input_s_0,
		R.xml.key_nico_katakana_half_input_t_0,
		R.xml.key_nico_katakana_half_input_n_0,
		R.xml.key_nico_katakana_half_input_h_0,
		R.xml.key_nico_katakana_half_input_m_0,
		R.xml.key_nico_katakana_half_input_y_0,
		R.xml.key_nico_katakana_half_input_r_0,
		R.xml.key_nico_katakana_half_input_w_0,
	};
	private static int selectPortKeyTable[] = {
		R.xml.key_nico_top_0,
		R.xml.key_nico_a_0,
		R.xml.key_nico_k_0,
		R.xml.key_nico_s_0,
		R.xml.key_nico_t_0,
		R.xml.key_nico_n_0,
		R.xml.key_nico_h_0,
		R.xml.key_nico_m_0,
		R.xml.key_nico_y_0,
		R.xml.key_nico_r_0,
		R.xml.key_nico_w_0,
		R.xml.key_nico_input_top_0,
		R.xml.key_nico_input_a_0,
		R.xml.key_nico_input_k_0,
		R.xml.key_nico_input_s_0,
		R.xml.key_nico_input_t_0,
		R.xml.key_nico_input_n_0,
		R.xml.key_nico_input_h_0,
		R.xml.key_nico_input_m_0,
		R.xml.key_nico_input_y_0,
		R.xml.key_nico_input_r_0,
		R.xml.key_nico_input_w_0,

		R.xml.key_nico_katakana_full_top_0,
		R.xml.key_nico_katakana_full_a_0,
		R.xml.key_nico_katakana_full_k_0,
		R.xml.key_nico_katakana_full_s_0,
		R.xml.key_nico_katakana_full_t_0,
		R.xml.key_nico_katakana_full_n_0,
		R.xml.key_nico_katakana_full_h_0,
		R.xml.key_nico_katakana_full_m_0,
		R.xml.key_nico_katakana_full_y_0,
		R.xml.key_nico_katakana_full_r_0,
		R.xml.key_nico_katakana_full_w_0,
		R.xml.key_nico_katakana_full_input_top_0,
		R.xml.key_nico_katakana_full_input_a_0,
		R.xml.key_nico_katakana_full_input_k_0,
		R.xml.key_nico_katakana_full_input_s_0,
		R.xml.key_nico_katakana_full_input_t_0,
		R.xml.key_nico_katakana_full_input_n_0,
		R.xml.key_nico_katakana_full_input_h_0,
		R.xml.key_nico_katakana_full_input_m_0,
		R.xml.key_nico_katakana_full_input_y_0,
		R.xml.key_nico_katakana_full_input_r_0,
		R.xml.key_nico_katakana_full_input_w_0,

		R.xml.key_nico_katakana_half_top_0,
		R.xml.key_nico_katakana_half_a_0,
		R.xml.key_nico_katakana_half_k_0,
		R.xml.key_nico_katakana_half_s_0,
		R.xml.key_nico_katakana_half_t_0,
		R.xml.key_nico_katakana_half_n_0,
		R.xml.key_nico_katakana_half_h_0,
		R.xml.key_nico_katakana_half_m_0,
		R.xml.key_nico_katakana_half_y_0,
		R.xml.key_nico_katakana_half_r_0,
		R.xml.key_nico_katakana_half_w_0,
		R.xml.key_nico_katakana_half_input_top_0,
		R.xml.key_nico_katakana_half_input_a_0,
		R.xml.key_nico_katakana_half_input_k_0,
		R.xml.key_nico_katakana_half_input_s_0,
		R.xml.key_nico_katakana_half_input_t_0,
		R.xml.key_nico_katakana_half_input_n_0,
		R.xml.key_nico_katakana_half_input_h_0,
		R.xml.key_nico_katakana_half_input_m_0,
		R.xml.key_nico_katakana_half_input_y_0,
		R.xml.key_nico_katakana_half_input_r_0,
		R.xml.key_nico_katakana_half_input_w_0,
	};

	// =========================================================

	private static int selectFlickLandKeyTable[] = {
		R.xml.key_nico_flick_top_0,
		R.xml.key_nico_a_0,
		R.xml.key_nico_k_0,
		R.xml.key_nico_s_0,
		R.xml.key_nico_t_0,
		R.xml.key_nico_n_0,
		R.xml.key_nico_h_0,
		R.xml.key_nico_m_0,
		R.xml.key_nico_y_0,
		R.xml.key_nico_r_0,
		R.xml.key_nico_w_0,
		R.xml.key_nico_flick_input_top_0,
		R.xml.key_nico_input_a_0,
		R.xml.key_nico_input_k_0,
		R.xml.key_nico_input_s_0,
		R.xml.key_nico_input_t_0,
		R.xml.key_nico_input_n_0,
		R.xml.key_nico_input_h_0,
		R.xml.key_nico_input_m_0,
		R.xml.key_nico_input_y_0,
		R.xml.key_nico_input_r_0,
		R.xml.key_nico_input_w_0,

		R.xml.key_nico_flick_katakana_full_top_0,
		R.xml.key_nico_katakana_full_a_0,
		R.xml.key_nico_katakana_full_k_0,
		R.xml.key_nico_katakana_full_s_0,
		R.xml.key_nico_katakana_full_t_0,
		R.xml.key_nico_katakana_full_n_0,
		R.xml.key_nico_katakana_full_h_0,
		R.xml.key_nico_katakana_full_m_0,
		R.xml.key_nico_katakana_full_y_0,
		R.xml.key_nico_katakana_full_r_0,
		R.xml.key_nico_katakana_full_w_0,
		R.xml.key_nico_flick_katakana_full_input_top_0,
		R.xml.key_nico_katakana_full_input_a_0,
		R.xml.key_nico_katakana_full_input_k_0,
		R.xml.key_nico_katakana_full_input_s_0,
		R.xml.key_nico_katakana_full_input_t_0,
		R.xml.key_nico_katakana_full_input_n_0,
		R.xml.key_nico_katakana_full_input_h_0,
		R.xml.key_nico_katakana_full_input_m_0,
		R.xml.key_nico_katakana_full_input_y_0,
		R.xml.key_nico_katakana_full_input_r_0,
		R.xml.key_nico_katakana_full_input_w_0,

		R.xml.key_nico_flick_katakana_half_top_0,
		R.xml.key_nico_katakana_half_a_0,
		R.xml.key_nico_katakana_half_k_0,
		R.xml.key_nico_katakana_half_s_0,
		R.xml.key_nico_katakana_half_t_0,
		R.xml.key_nico_katakana_half_n_0,
		R.xml.key_nico_katakana_half_h_0,
		R.xml.key_nico_katakana_half_m_0,
		R.xml.key_nico_katakana_half_y_0,
		R.xml.key_nico_katakana_half_r_0,
		R.xml.key_nico_katakana_half_w_0,
		R.xml.key_nico_flick_katakana_half_input_top_0,
		R.xml.key_nico_katakana_half_input_a_0,
		R.xml.key_nico_katakana_half_input_k_0,
		R.xml.key_nico_katakana_half_input_s_0,
		R.xml.key_nico_katakana_half_input_t_0,
		R.xml.key_nico_katakana_half_input_n_0,
		R.xml.key_nico_katakana_half_input_h_0,
		R.xml.key_nico_katakana_half_input_m_0,
		R.xml.key_nico_katakana_half_input_y_0,
		R.xml.key_nico_katakana_half_input_r_0,
		R.xml.key_nico_katakana_half_input_w_0,
	};
	private static int selectFlickPortKeyTable[] = {
		R.xml.key_nico_flick_top_0,
		R.xml.key_nico_a_0,
		R.xml.key_nico_k_0,
		R.xml.key_nico_s_0,
		R.xml.key_nico_t_0,
		R.xml.key_nico_n_0,
		R.xml.key_nico_h_0,
		R.xml.key_nico_m_0,
		R.xml.key_nico_y_0,
		R.xml.key_nico_r_0,
		R.xml.key_nico_w_0,
		R.xml.key_nico_flick_input_top_0,
		R.xml.key_nico_input_a_0,
		R.xml.key_nico_input_k_0,
		R.xml.key_nico_input_s_0,
		R.xml.key_nico_input_t_0,
		R.xml.key_nico_input_n_0,
		R.xml.key_nico_input_h_0,
		R.xml.key_nico_input_m_0,
		R.xml.key_nico_input_y_0,
		R.xml.key_nico_input_r_0,
		R.xml.key_nico_input_w_0,

		R.xml.key_nico_flick_katakana_full_top_0,
		R.xml.key_nico_katakana_full_a_0,
		R.xml.key_nico_katakana_full_k_0,
		R.xml.key_nico_katakana_full_s_0,
		R.xml.key_nico_katakana_full_t_0,
		R.xml.key_nico_katakana_full_n_0,
		R.xml.key_nico_katakana_full_h_0,
		R.xml.key_nico_katakana_full_m_0,
		R.xml.key_nico_katakana_full_y_0,
		R.xml.key_nico_katakana_full_r_0,
		R.xml.key_nico_katakana_full_w_0,
		R.xml.key_nico_flick_katakana_full_input_top_0,
		R.xml.key_nico_katakana_full_input_a_0,
		R.xml.key_nico_katakana_full_input_k_0,
		R.xml.key_nico_katakana_full_input_s_0,
		R.xml.key_nico_katakana_full_input_t_0,
		R.xml.key_nico_katakana_full_input_n_0,
		R.xml.key_nico_katakana_full_input_h_0,
		R.xml.key_nico_katakana_full_input_m_0,
		R.xml.key_nico_katakana_full_input_y_0,
		R.xml.key_nico_katakana_full_input_r_0,
		R.xml.key_nico_katakana_full_input_w_0,

		R.xml.key_nico_flick_katakana_half_top_0,
		R.xml.key_nico_katakana_half_a_0,
		R.xml.key_nico_katakana_half_k_0,
		R.xml.key_nico_katakana_half_s_0,
		R.xml.key_nico_katakana_half_t_0,
		R.xml.key_nico_katakana_half_n_0,
		R.xml.key_nico_katakana_half_h_0,
		R.xml.key_nico_katakana_half_m_0,
		R.xml.key_nico_katakana_half_y_0,
		R.xml.key_nico_katakana_half_r_0,
		R.xml.key_nico_katakana_half_w_0,
		R.xml.key_nico_flick_katakana_half_input_top_0,
		R.xml.key_nico_katakana_half_input_a_0,
		R.xml.key_nico_katakana_half_input_k_0,
		R.xml.key_nico_katakana_half_input_s_0,
		R.xml.key_nico_katakana_half_input_t_0,
		R.xml.key_nico_katakana_half_input_n_0,
		R.xml.key_nico_katakana_half_input_h_0,
		R.xml.key_nico_katakana_half_input_m_0,
		R.xml.key_nico_katakana_half_input_y_0,
		R.xml.key_nico_katakana_half_input_r_0,
		R.xml.key_nico_katakana_half_input_w_0,
	};

}
/******************** end of file ********************/
