/**
 * 
 */
package net.gorry.android.input.nicownng;

import java.util.List;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.inputmethodservice.Keyboard;
import android.util.Log;

/**
 * 
 * 高さを変更できるキーボード
 * 
 * @author GORRY
 *
 */
public class MyHeightKeyboard extends Keyboard {
	private static final String TAG = "MyHeightKeyboard";
	private static final boolean V = false;

	private static final int keyHeightTablePortrait[] = {
		36, 48, 60, 72, 84, 96, 108, 120,
	};
	private static final int keyHeightTableLandscape[] = {
		24, 36, 48, 60, 72, 84, 96, 108,
	};

	private Context mContext;
	private int mTotalHeight;
	private int mIndexShiftKey = -1;
	private List<Key> mKeys;

	private static final int popupKeyboardTable_12key[] = {
		R.xml.keyboard_popup_12key_jp_0,
		R.xml.keyboard_popup_12key_jp_1,
		R.xml.keyboard_popup_12key_jp_2,
		R.xml.keyboard_popup_12key_jp_3,
		R.xml.keyboard_popup_12key_jp_4,
		R.xml.keyboard_popup_12key_jp_5,
		R.xml.keyboard_popup_12key_jp_6,
		R.xml.keyboard_popup_12key_jp_7,
	};
	
	private static final int popupKeyboardTable_qwerty[] = {
		R.xml.keyboard_popup_qwerty_jp_0,
		R.xml.keyboard_popup_qwerty_jp_1,
		R.xml.keyboard_popup_qwerty_jp_2,
		R.xml.keyboard_popup_qwerty_jp_3,
		R.xml.keyboard_popup_qwerty_jp_4,
		R.xml.keyboard_popup_qwerty_jp_5,
		R.xml.keyboard_popup_qwerty_jp_6,
		R.xml.keyboard_popup_qwerty_jp_7,
	};
	
	private static final int popupKeyboardTable_nico2[] = {
		R.xml.keyboard_popup_nico2_jp_0,
		R.xml.keyboard_popup_nico2_jp_1,
		R.xml.keyboard_popup_nico2_jp_2,
		R.xml.keyboard_popup_nico2_jp_3,
		R.xml.keyboard_popup_nico2_jp_4,
		R.xml.keyboard_popup_nico2_jp_5,
		R.xml.keyboard_popup_nico2_jp_6,
		R.xml.keyboard_popup_nico2_jp_7,
	};

	private static final int popupKeyboardTable[][] = {
		popupKeyboardTable_12key,  // KEYTYPE_12KEY
		popupKeyboardTable_qwerty, // KEYTYPE_QWERTY
		popupKeyboardTable_nico2,  // KEYTYPE_NICO2
	};

	/**
	 * @param context context
	 * @param xmlLayoutResId resid
	 * @param heightIndex height
	 * @param isPortrait portrait
	 */
	public MyHeightKeyboard(Context context, int xmlLayoutResId, int heightIndex, int keyType, boolean isPortrait) {
		super(context, xmlLayoutResId);
		
		mContext = context;
		final int[] htable = (isPortrait ? keyHeightTablePortrait : keyHeightTableLandscape);
		final int height = htable[heightIndex];
		mKeys = this.getKeys();
		// Log.d("nicoWnnG", "keys.size="+keys.size());
		int maxy = 0;
		int maxheight = 0;
		mIndexShiftKey = -1;
		for (int i=0; i<mKeys.size(); i++) {
			Key key = mKeys.get(i);
			// Log.d("nicoWnnG", i+": w="+key.width+",h="+key.height+",label="+key.label+",text="+key.text);

			// ポップアップキーボードのサイズ変更
			if (key.codes.length > 0) {
				if (key.codes[0] == DefaultSoftKeyboard.KEYCODE_JP12_TOGGLE_MODE) {
					int n = 0;
					for (int j=0; j<htable.length; j++) {
						if (height >= htable[j]) {
							n = j;
						}
					}
					key.popupResId = popupKeyboardTable[keyType][n];
					// Log.d("nicoWnnG", "resourceName="+context.getResources().getResourceName(key.popupResId));
				}
			}

			// キーサイズ変更
			key.y *= height;
			key.height *= height;
			if (maxy < key.y) {
				maxy = key.y;
				maxheight = 0;
			}
			if (maxheight < key.height) {
				maxheight = key.height;
			}

			// Shiftキーを覚えておく
			if (key.codes[0] == -1) {
				mIndexShiftKey = i;
			}
		}
		mTotalHeight = maxy + maxheight;
	}

	@Override
	public int getHeight() {
		return mTotalHeight;
	}
	
	public void setShiftKeyIconLock(boolean sw) {
		Key key;
		int id1, id2;
		Drawable d;

		if (mIndexShiftKey < 0) {
			return;
		}
		if (mIndexShiftKey >= mKeys.size()) {
			return;
		}
		id1 = R.drawable.key_qwerty_shift;
		id2 = R.drawable.key_qwerty_shift_b;
		if (sw) {
			id1 = R.drawable.key_qwerty_shiftlock;
			id2 = R.drawable.key_qwerty_shiftlock_b;
		}
		key = mKeys.get(mIndexShiftKey);
		d = mContext.getResources().getDrawable(id1);
		if (d != null) d.setBounds(0, 0, d.getIntrinsicWidth(), d.getIntrinsicHeight());
		key.icon = d;
		d = mContext.getResources().getDrawable(id2);
		if (d != null) d.setBounds(0, 0, d.getIntrinsicWidth(), d.getIntrinsicHeight());
		key.iconPreview = d;
	}
}
