/*
 */
package net.gorry.android.input.nicownng;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.preference.PreferenceManager;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.WindowManager;
import android.webkit.WebView;
import android.widget.Toast;
import android.os.Build;

public class NicoWnnGMain extends Activity {
	@Override public void onCreate(final Bundle saveInstanceState) {
		super.onCreate(saveInstanceState);

		final WebView webView = new WebView(this);
		webView.getSettings().setJavaScriptEnabled(true);
		final Js2Java js2Java = new Js2Java(this);
		webView.addJavascriptInterface(js2Java, "android");
		webView.loadUrl("file:///android_asset/openwnn_main.html");
		setContentView(webView);

		if (NicoWnnGJAJP.getInstance() == null) {
			new NicoWnnGJAJP(this);
		}
		NicoWnnGJAJP.getInstance().initializeEasySetting();
		NicoWnnGJAJP.getInstance().convertOldPreferces();

	}

	public class Js2Java {
		private final Context me;

		public Js2Java(final Context context) {
			me = context;
		}

		public void callback(final String msg) {
			if (msg.equalsIgnoreCase("languageSetting")) {
				final Intent intent = new Intent(Intent.ACTION_MAIN);
				if (Build.VERSION.SDK_INT >= 14) {
					intent.setClassName("com.android.settings", "com.android.settings.Settings$InputMethodAndLanguageSettingsActivity");
				} else if (Build.VERSION.SDK_INT >= 11) {
					intent.setClassName("com.android.settings", "com.android.settings.Settings$InputMethodConfigActivity");
				} else {
					intent.setClassName("com.android.settings", "com.android.settings.LanguageSettings");
				}
				try {
					me.startActivity(intent);
				} catch (final Exception e) {
					Toast.makeText(
							getApplicationContext(),
							R.string.js2java_error_languagesetting,
							Toast.LENGTH_LONG
					).show();
				}
				return;
			}
			if (msg.equalsIgnoreCase("config")) {
				final Intent intent = new Intent(
						me, NicoWnnGControlPanelJAJP.class
				);
				intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
				try {
					me.startActivity(intent);
				} catch (final Exception e) {
					Toast.makeText(
							getApplicationContext(),
							R.string.js2java_error_config,
							Toast.LENGTH_LONG
					).show();
				}
				return;
			}
			if (msg.substring(0, 5).equalsIgnoreCase("easy_")) {
				final int mode = Integer.parseInt(msg.substring(5, 6));
				final int size = Integer.parseInt(msg.substring(7, 8));
				if (NicoWnnGJAJP.getInstance() == null) {
					new NicoWnnGJAJP(me);
				}
				NicoWnnGJAJP.getInstance().setEasySetting(mode, size);
				Toast.makeText(
						getApplicationContext(),
						R.string.js2java_accepted_easy,
						Toast.LENGTH_LONG
				).show();
				return;
			}
		}
	}

}